/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.platform.gnome;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.net.URI;
import net.filebot.platform.gnome.GVFS;
import net.filebot.platform.gnome.LibGIO;

public class NativeGVFS
implements GVFS {
    private static final LibGIO lib_gio = Native.loadLibrary("gio-2.0", LibGIO.class);
    private static final Pointer gvfs = lib_gio.g_vfs_get_default();

    @Override
    public File getPathForURI(URI uri) {
        Pointer gfile = lib_gio.g_vfs_get_file_for_uri(gvfs, uri.toString());
        Pointer chars = lib_gio.g_file_get_path(gfile);
        try {
            if (chars != null) {
                File file = new File(chars.getString(0L));
                return file;
            }
            throw new IllegalArgumentException("Failed to locate local path: " + uri);
        }
        finally {
            lib_gio.g_object_unref(gfile);
            lib_gio.g_free(chars);
        }
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), lib_gio);
    }
}

