/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.platform.gnome;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.filebot.platform.gnome.GVFS;

public class PlatformGVFS
implements GVFS {
    private File gvfs;

    public PlatformGVFS(File gvfs) {
        this.gvfs = gvfs;
    }

    @Override
    public File getPathForURI(URI uri) {
        return Protocol.forName(uri.getScheme()).getFile(this.gvfs, uri);
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), this.gvfs);
    }

    public static enum Protocol {
        FILE{

            @Override
            public File getFile(File gvfs, URI uri) {
                return new File(uri);
            }

            @Override
            public String getPath(URI uri) {
                return new File(uri).getPath();
            }
        }
        ,
        SMB{

            @Override
            public String getPath(URI uri) {
                StringBuilder s = new StringBuilder("smb-share:");
                s.append("server=").append(uri.getHost());
                if (uri.getUserInfo() != null) {
                    s.append(",user=").append(uri.getUserInfo());
                }
                s.append(",share=").append(uri.getPath().substring(1));
                return s.toString();
            }
        }
        ,
        AFP{

            @Override
            public String getPath(URI uri) {
                StringBuilder s = new StringBuilder("afp-volume:");
                s.append("host=").append(uri.getHost());
                if (uri.getUserInfo() != null) {
                    s.append(",user=").append(uri.getUserInfo());
                }
                s.append(",volume=").append(uri.getPath().substring(1));
                return s.toString();
            }
        }
        ,
        SFTP{

            @Override
            public String getPath(URI uri) {
                StringBuilder s = new StringBuilder("sftp:");
                s.append("host=").append(uri.getHost());
                if (uri.getUserInfo() != null) {
                    s.append(",user=").append(uri.getUserInfo());
                }
                s.append(uri.getPath());
                return s.toString();
            }
        };


        public abstract String getPath(URI var1);

        public File getFile(File gvfs, URI uri) {
            return new File(gvfs, this.getPath(uri));
        }

        public static List<String> names() {
            return Arrays.stream(Protocol.values()).map(Enum::name).collect(Collectors.toList());
        }

        public static Protocol forName(String name) {
            for (Protocol protocol : Protocol.values()) {
                if (!protocol.name().equalsIgnoreCase(name)) continue;
                return protocol;
            }
            throw new IllegalArgumentException(String.format("%s not in %s", name, Protocol.names()));
        }
    }
}

