/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.platform.mac;

import ca.weblite.objc.Client;
import ca.weblite.objc.Proxy;
import ca.weblite.objc.util.CocoaUtils;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.QuitStrategy;
import com.apple.eio.FileManager;
import com.sun.jna.Pointer;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import net.filebot.Logging;
import net.filebot.platform.mac.DropToUnlock;

public class MacAppUtilities {
    private static Client _objc;

    public static Client objc() {
        if (_objc == null) {
            _objc = new Client();
        }
        return _objc;
    }

    public static Object NSData_initWithBase64Encoding(String text) {
        return MacAppUtilities.objc().sendProxy("NSData", "data", new Object[0]).send("initWithBase64Encoding:", text);
    }

    public static String NSURL_bookmarkDataWithOptions(String path) {
        return MacAppUtilities.objc().sendProxy("NSURL", "fileURLWithPath:", path).sendProxy("bookmarkDataWithOptions:includingResourceValuesForKeys:relativeToURL:error:", 2048, null, null, null).sendString("base64Encoding", new Object[0]);
    }

    public static Object NSURL_URLByResolvingBookmarkData_startAccessingSecurityScopedResource(String text) {
        return MacAppUtilities.objc().sendProxy("NSURL", "URLByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:", MacAppUtilities.NSData_initWithBase64Encoding(text), 1024, null, false, null).send("startAccessingSecurityScopedResource", new Object[0]);
    }

    public static List<File> NSOpenPanel_openPanel_runModal(String title, boolean multipleMode, boolean canChooseDirectories, boolean canChooseFiles, String[] allowedFileTypes) {
        ArrayList<File> result = new ArrayList<File>();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
        CocoaUtils.dispatch_async(() -> {
            Pointer pool = CocoaUtils.createAutoreleasePool();
            Proxy peer = MacAppUtilities.objc().sendProxy("NSOpenPanel", "openPanel", new Object[0]);
            peer.send("retain", new Object[0]);
            peer.send("setTitle:", title);
            peer.send("setAllowsMultipleSelection:", multipleMode ? 1 : 0);
            peer.send("setCanChooseDirectories:", canChooseDirectories ? 1 : 0);
            peer.send("setCanChooseFiles:", canChooseFiles ? 1 : 0);
            if (allowedFileTypes != null) {
                Proxy mutableArray = MacAppUtilities.objc().sendProxy("NSMutableArray", "arrayWithCapacity:", allowedFileTypes.length);
                for (String type : allowedFileTypes) {
                    mutableArray.send("addObject:", type);
                }
                peer.send("setAllowedFileTypes:", mutableArray);
            }
            if (peer.sendInt("runModal", new Object[0]) != 0) {
                Proxy nsArray = peer.getProxy("URLs");
                int size = nsArray.sendInt("count", new Object[0]);
                for (int i = 0; i < size; ++i) {
                    Proxy url = nsArray.sendProxy("objectAtIndex:", i);
                    String path = url.sendString("path", new Object[0]);
                    result.add(new File(path));
                }
            }
            CocoaUtils.drainAutoreleasePool(pool);
            secondaryLoop.exit();
        });
        if (!secondaryLoop.enter()) {
            throw new IllegalStateException("SecondaryLoop");
        }
        return result;
    }

    public static void setWindowCanFullScreen(Window window) {
        try {
            FullScreenUtilities.setWindowCanFullScreen((Window)window, (boolean)true);
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void requestForeground() {
        try {
            Application.getApplication().requestForeground(true);
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void revealInFinder(File file) {
        try {
            FileManager.revealInFinder((File)file);
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void moveToTrash(File file) {
        try {
            FileManager.moveToTrash((File)file);
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void setDefaultMenuBar(JMenuBar menu) {
        try {
            Application.getApplication().setDefaultMenuBar(menu);
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void setQuitStrategyCloseAll() {
        try {
            Application.getApplication().setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void setOpenFileHandler(Consumer<List<File>> handler) {
        try {
            Application.getApplication().setOpenFileHandler(evt -> {
                List files = evt.getFiles();
                if (files.size() > 0) {
                    handler.accept(files);
                }
            });
        }
        catch (Throwable t) {
            Logging.debug.log(Level.WARNING, t.getMessage(), t);
        }
    }

    public static void initializeApplication() {
        UIManager.put("TitledBorder.border", UIManager.getBorder("InsetBorder.aquaVariant"));
        MacAppUtilities.setQuitStrategyCloseAll();
    }

    public static boolean isLockedFolder(File folder) {
        return folder.isDirectory() && !folder.canRead();
    }

    public static boolean askUnlockFolders(Window owner, Collection<File> files) {
        return DropToUnlock.showUnlockFoldersDialog(owner, files);
    }

    private MacAppUtilities() {
        throw new UnsupportedOperationException();
    }
}

