/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.filebot.Logging;
import net.filebot.similarity.Match;
import net.filebot.similarity.SimilarityMetric;

public class Matcher<V, C> {
    protected final List<V> values;
    protected final List<C> candidates;
    protected final boolean strict;
    protected final SimilarityMetric[] metrics;
    protected final DisjointMatchCollection<V, C> disjointMatchCollection;

    public Matcher(Collection<? extends V> values, Collection<? extends C> candidates, boolean strict, SimilarityMetric[] metrics) {
        this.values = new LinkedList<V>(values);
        this.candidates = new LinkedList<C>(candidates);
        this.strict = strict;
        this.metrics = (SimilarityMetric[])metrics.clone();
        this.disjointMatchCollection = new DisjointMatchCollection();
    }

    public synchronized List<Match<V, C>> match() throws InterruptedException {
        ArrayList<Match<V, C>> possibleMatches = new ArrayList<Match<V, C>>(this.values.size() * this.candidates.size());
        for (V value : this.values) {
            for (C candidate : this.candidates) {
                possibleMatches.add(new Match<V, C>(value, candidate));
            }
        }
        this.deepMatch(possibleMatches, 0);
        ArrayList<Match<V, C>> result = new ArrayList<Match<V, C>>();
        for (V v : this.values) {
            Match<V, C> match = this.disjointMatchCollection.getByValue(v);
            if (match == null) continue;
            result.add(match);
        }
        for (Match match : result) {
            this.values.remove(match.getValue());
            this.candidates.remove(match.getCandidate());
        }
        this.disjointMatchCollection.clear();
        return result;
    }

    public synchronized List<V> remainingValues() {
        return Collections.unmodifiableList(this.values);
    }

    public synchronized List<C> remainingCandidates() {
        return Collections.unmodifiableList(this.candidates);
    }

    protected void deepMatch(Collection<Match<V, C>> possibleMatches, int level) throws InterruptedException {
        if (level >= this.metrics.length || possibleMatches.isEmpty()) {
            if (!this.strict) {
                ArrayList<Match<V, C>> rest = new ArrayList<Match<V, C>>(possibleMatches);
                Collections.sort(rest, new Comparator<Match<V, C>>(){

                    @Override
                    public int compare(Match<V, C> o1, Match<V, C> o2) {
                        return o1.toString().compareToIgnoreCase(o2.toString());
                    }
                });
                this.disjointMatchCollection.addAll(rest);
            }
            return;
        }
        for (Set<Match<V, C>> matchesWithEqualSimilarity : this.mapBySimilarity(possibleMatches, this.metrics[level]).values()) {
            List<Match<V, C>> disjointMatches = this.disjointMatches(matchesWithEqualSimilarity);
            if (!disjointMatches.isEmpty()) {
                this.disjointMatchCollection.addAll(disjointMatches);
                matchesWithEqualSimilarity.removeAll(disjointMatches);
            }
            this.removeCollected(matchesWithEqualSimilarity);
            this.deepMatch(matchesWithEqualSimilarity, level + 1);
        }
    }

    protected void removeCollected(Collection<Match<V, C>> matches) {
        Iterator<Match<V, C>> iterator = matches.iterator();
        while (iterator.hasNext()) {
            if (this.disjointMatchCollection.disjoint(iterator.next())) continue;
            iterator.remove();
        }
    }

    protected SortedMap<Float, Set<Match<V, C>>> mapBySimilarity(Collection<Match<V, C>> possibleMatches, SimilarityMetric metric) throws InterruptedException {
        TreeMap<Float, Set<Match<LinkedHashSet<Match<V, C>>, C>>> similarityMap = new TreeMap<Float, Set<Match<LinkedHashSet<Match<V, C>>, C>>>(Collections.reverseOrder());
        for (Match<V, C> possibleMatch : possibleMatches) {
            float similarity = metric.getSimilarity(possibleMatch.getValue(), possibleMatch.getCandidate());
            Logging.debug.finest(Logging.format("%s %.04f => %s", metric, Float.valueOf(similarity), possibleMatch));
            LinkedHashSet<Match<V, C>> matchSet = (LinkedHashSet<Match<V, C>>)similarityMap.get(Float.valueOf(similarity));
            if (matchSet == null) {
                matchSet = new LinkedHashSet<Match<V, C>>();
                similarityMap.put(Float.valueOf(similarity), matchSet);
            }
            matchSet.add(possibleMatch);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        return similarityMap;
    }

    protected List<Match<V, C>> disjointMatches(Collection<Match<V, C>> collection) {
        HashMap<V, ArrayList<Match<V, C>>> matchesByValue = new HashMap<V, ArrayList<Match<V, C>>>();
        HashMap matchesByCandidate = new HashMap();
        for (Match<V, C> match : collection) {
            List<Match<Object, Object>> matchListForValue = (ArrayList<Match<V, C>>)matchesByValue.get(match.getValue());
            ArrayList<Match<V, C>> matchListForCandidate = (ArrayList<Match<V, C>>)matchesByCandidate.get(match.getCandidate());
            if (matchListForValue == null) {
                matchListForValue = new ArrayList<Match<V, C>>();
                matchesByValue.put(match.getValue(), (ArrayList<Match<V, C>>)matchListForValue);
            }
            if (matchListForCandidate == null) {
                matchListForCandidate = new ArrayList<Match<V, C>>();
                matchesByCandidate.put(match.getCandidate(), matchListForCandidate);
            }
            matchListForValue.add(match);
            matchListForCandidate.add(match);
        }
        ArrayList<Match<V, C>> disjointMatches = new ArrayList<Match<V, C>>();
        for (List<Match<Object, Object>> matchListForValue : matchesByValue.values()) {
            if (matchListForValue.size() != 1 || !matchListForValue.equals(matchesByCandidate.get(((Match)matchListForValue.get(0)).getCandidate()))) continue;
            disjointMatches.add((Match<V, C>)matchListForValue.get(0));
        }
        return disjointMatches;
    }

    protected static class DisjointMatchCollection<V, C>
    extends AbstractList<Match<V, C>> {
        private final List<Match<V, C>> matches = new ArrayList<Match<V, C>>();
        private final Map<V, Match<V, C>> values = new IdentityHashMap<V, Match<V, C>>();
        private final Map<C, Match<V, C>> candidates = new IdentityHashMap<C, Match<V, C>>();

        protected DisjointMatchCollection() {
        }

        @Override
        public boolean add(Match<V, C> match) {
            if (this.disjoint(match)) {
                this.values.put((Match<V, C>)match.getValue(), (Match<Match<V, C>, C>)match);
                this.candidates.put(match.getCandidate(), match);
                return this.matches.add(match);
            }
            return false;
        }

        public boolean disjoint(Match<V, C> match) {
            return !this.values.containsKey(match.getValue()) && !this.candidates.containsKey(match.getCandidate());
        }

        public Match<V, C> getByValue(V value) {
            return this.values.get(value);
        }

        public Match<V, C> getByCandidate(C candidate) {
            return this.candidates.get(candidate);
        }

        @Override
        public Match<V, C> get(int index) {
            return this.matches.get(index);
        }

        @Override
        public int size() {
            return this.matches.size();
        }

        @Override
        public void clear() {
            this.matches.clear();
            this.values.clear();
            this.candidates.clear();
        }
    }
}

