/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.Arrays;
import net.filebot.similarity.SimilarityMetric;

public class MetricCascade
implements SimilarityMetric {
    private final SimilarityMetric[] cascade;

    public MetricCascade(SimilarityMetric ... cascade) {
        this.cascade = cascade;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        float f = 0.0f;
        for (SimilarityMetric metric : this.cascade) {
            float similarity = metric.getSimilarity(o1, o2);
            if (!(Math.abs(similarity) >= Math.abs(f))) continue;
            if (similarity >= 1.0f) {
                return similarity;
            }
            f = similarity;
        }
        return f;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + Arrays.asList(this.cascade);
    }
}

