/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.filebot.util.RegularExpressions;

public class Normalization {
    public static final Pattern APOSTROPHE = Pattern.compile("['`\u00b4\u2018\u2019\u02bb]+");
    public static final Pattern PUNCTUATION_OR_SPACE = Pattern.compile("[\\p{Punct}\\p{Space}]+", 256);
    public static final Pattern WORD_SEPARATOR_PUNCTUATION = Pattern.compile("[:?._]");
    public static final Pattern TRAILING_PARENTHESIS = Pattern.compile("(?<!^)[(]([^)]*)[)]$");
    public static final Pattern TRAILING_PUNCTUATION = Pattern.compile("[!?.]+$");
    public static final Pattern EMBEDDED_CHECKSUM = Pattern.compile("[\\(\\[](\\p{XDigit}{8})[\\]\\)]");
    private static final Pattern[] BRACKETS = new Pattern[]{Pattern.compile("\\([^\\(]*\\)"), Pattern.compile("\\[[^\\[]*\\]"), Pattern.compile("\\{[^\\{]*\\}")};
    private static final char[][] QUOTES = new char[][]{{'\'', '`', '\u00b4', '\u2018', '\u2019', '\u02bb'}, {'\"', '\u201c', '\u201d'}};

    public static String normalizeQuotationMarks(String name) {
        char[][] cArray = QUOTES;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char[] cs;
            for (char c : cs = cArray[i]) {
                name = name.replace(c, cs[0]);
            }
        }
        return name;
    }

    public static String trimTrailingPunctuation(CharSequence name) {
        return Normalization.normalize(name, TRAILING_PUNCTUATION, "");
    }

    public static String normalizePunctuation(String name) {
        return Normalization.normalizePunctuation(name, "", " ");
    }

    public static String normalizePunctuation(String name, String apostrophe, String space) {
        Pattern[] pattern = new Pattern[]{APOSTROPHE, PUNCTUATION_OR_SPACE};
        String[] replacement = new String[]{apostrophe, space};
        return Normalization.normalize(name, pattern, replacement);
    }

    public static String normalizeBrackets(String name) {
        return Normalization.normalize(name, BRACKETS, " ");
    }

    public static String normalizeSpace(String name, String space) {
        Pattern[] patterns = new Pattern[]{WORD_SEPARATOR_PUNCTUATION, RegularExpressions.SPACE};
        String[] replacements = new String[]{" ", space};
        return Normalization.normalize(name, patterns, replacements);
    }

    public static String replaceSpace(CharSequence name, String replacement) {
        return Normalization.normalize(name, RegularExpressions.SPACE, replacement);
    }

    public static String replaceColon(String name, String ratio, String colon) {
        Pattern[] pattern = new Pattern[]{RegularExpressions.RATIO, RegularExpressions.COLON};
        String[] replacement = new String[]{ratio, colon};
        return Normalization.normalize(name, pattern, replacement);
    }

    public static String getEmbeddedChecksum(CharSequence name) {
        Matcher m = EMBEDDED_CHECKSUM.matcher(name);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String removeEmbeddedChecksum(CharSequence name) {
        return Normalization.normalize(name, EMBEDDED_CHECKSUM, "");
    }

    public static String removeTrailingBrackets(CharSequence name) {
        return Normalization.normalize(name, TRAILING_PARENTHESIS, "");
    }

    private static String normalize(CharSequence name, Pattern pattern, String replacement) {
        return pattern.matcher(name).replaceAll(Matcher.quoteReplacement(replacement)).trim();
    }

    private static String normalize(String name, Pattern[] pattern, String replacement) {
        for (int i = 0; i < pattern.length; ++i) {
            name = Normalization.normalize((CharSequence)name, pattern[i], replacement);
        }
        return name;
    }

    private static String normalize(String name, Pattern[] pattern, String[] replacement) {
        for (int i = 0; i < pattern.length; ++i) {
            name = Normalization.normalize((CharSequence)name, pattern[i], replacement[i]);
        }
        return name;
    }

    public static String truncateText(String title, int limit) {
        if (title == null || title.length() < limit) {
            return title;
        }
        String[] words = RegularExpressions.SPACE.split(title);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < words.length && s.length() + words[i].length() < limit; ++i) {
            if (i > 0) {
                s.append(' ');
            }
            s.append(words[i]);
        }
        return s.toString().trim();
    }
}

