/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.util.RegularExpressions;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.wordhandlers.DummyStopTermHandler;
import uk.ac.shef.wit.simmetrics.wordhandlers.InterfaceTermHandler;

public class NumericSimilarityMetric
implements SimilarityMetric {
    private final AbstractStringMetric metric = new QGramsDistance(new NumberTokeniser());

    @Override
    public float getSimilarity(Object o1, Object o2) {
        return this.metric.getSimilarity(this.normalize(o1), this.normalize(o2));
    }

    protected String normalize(Object object) {
        return object.toString();
    }

    private static class NumberTokeniser
    implements InterfaceTokeniser {
        private InterfaceTermHandler stopWordHandler = new DummyStopTermHandler();

        private NumberTokeniser() {
        }

        @Override
        public ArrayList<String> tokenizeToArrayList(String s) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher m = RegularExpressions.DIGIT.matcher(s);
            while (m.find()) {
                tokens.add(new Integer(m.group()).toString());
            }
            return tokens;
        }

        @Override
        public String getDelimiters() {
            return RegularExpressions.NON_DIGIT.pattern();
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            return new LinkedHashSet<String>(this.tokenizeToArrayList(input));
        }

        @Override
        public String getShortDescriptionString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public InterfaceTermHandler getStopWordHandler() {
            return this.stopWordHandler;
        }

        @Override
        public void setStopWordHandler(InterfaceTermHandler stopWordHandler) {
            this.stopWordHandler = stopWordHandler;
        }
    }
}

