/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IntSummaryStatistics;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.util.StringUtilities;

public class SeasonEpisodeMatcher {
    public static final SeasonEpisodeFilter LENIENT_SANITY = new SeasonEpisodeFilter(99, 999, 9999, 1970, 2100);
    public static final SeasonEpisodeFilter DEFAULT_SANITY = new SeasonEpisodeFilter(50, 50, 1000, 1970, 2100);
    public static final SeasonEpisodeFilter STRICT_SANITY = new SeasonEpisodeFilter(10, 30, -1, -1, -1);
    private SeasonEpisodeParser[] patterns;
    private Pattern seasonPattern;

    public SeasonEpisodeMatcher(SeasonEpisodeFilter sanity, boolean strict) {
        SeasonEpisodePattern Season_00_Episode_00 = new SeasonEpisodePattern(null, "(?<!\\p{Alnum})(?i:season|series)[^\\p{Alnum}]{0,3}(\\d{1,4})[^\\p{Alnum}]{0,3}(?i:episode)[^\\p{Alnum}]{0,3}((\\d{1,3}(\\D|$))+)[^\\p{Alnum}]{0,3}(?!\\p{Digit})", m -> this.range(m.group(1), m.group(2)));
        SeasonEpisodePattern S00E00SEQ = new SeasonEpisodePattern(null, "(?<!\\p{Alnum}|[-])[Ss](\\d{1,2}|\\d{4})[Ee](\\d{2,3})[-][Ee](\\d{2,3})(?!\\p{Alnum}|[-])", m -> this.range(m.group(1), m.group(2), m.group(3)));
        SeasonEpisodePattern S00E00 = new SeasonEpisodePattern(null, "(?<!\\p{Digit})[Ss](\\d{1,2}|\\d{4})[^\\p{Alnum}]{0,3}(?i:ep|e|p)(((?<=[^._ ])[Ee]?[Pp]?\\d{1,3}(\\D|$))+)", m -> this.multi(m.group(1), m.group(2)));
        SeasonEpisodePattern SxE1_SxE2 = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum})(\\d{1,2}x\\d{2}([-._ ]\\d{1,2}x\\d{2})+)(?!\\p{Digit})", m -> this.pairs(m.group()));
        SeasonEpisodePattern SxE2 = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum})(\\d{1,2})[xe](((?<=[^._ ])\\d{2,3}(\\D|$))+)", m -> this.multi(m.group(1), m.group(2)));
        SeasonEpisodePattern Dot101 = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum}|\\d{4}[.])(\\d{1,2})[.](((?<=[^._ ])\\d{2}(\\D|$))+)", m -> this.multi(m.group(1), m.group(2)));
        SeasonEpisodePattern E01E02SEQ = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum}|[-])(\\d{2,3})[-](\\d{2,3})(?!\\p{Alnum}|[-])", m -> this.range(null, m.group(1), m.group(2)));
        SeasonEpisodePattern EP0 = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum})(\\d{2}|\\d{4})?[\\P{Alnum}]{0,3}(((?i:e|ep|episode|p|part)[\\P{Alnum}]{0,3}\\d{1,3})+)(?!\\p{Digit})", m -> this.multi(m.group(1), m.group(2)));
        SeasonEpisodePattern Num101_TOKEN = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum})([0-2]?\\d?)(\\d{2})(\\d{2})?(?!\\p{Alnum})", m -> this.numbers(m.group(1), (String[])StringUtilities.streamCapturingGroups(m).skip(1L).toArray(String[]::new)));
        SeasonEpisodePattern E1of2 = new SeasonEpisodePattern(sanity, "(?<!\\p{Alnum})(\\d{1,2})[^._ ]?(?i:of)[^._ ]?(\\d{1,2})(?!\\p{Digit})", m -> this.single(null, m.group(1)));
        SeasonEpisodePattern Num101_SUBSTRING = new SeasonEpisodePattern(STRICT_SANITY, "(?<!\\p{Digit})(\\d{1})(\\d{2})(?!\\p{Digit})(.*)", m -> this.single(m.group(1), m.group(2)));
        this.patterns = strict ? new SeasonEpisodeParser[]{Season_00_Episode_00, S00E00SEQ, S00E00, SxE1_SxE2, SxE2, Dot101} : new SeasonEpisodeParser[]{Season_00_Episode_00, S00E00SEQ, S00E00, SxE1_SxE2, SxE2, Dot101, E01E02SEQ, new SeasonEpisodeUnion(EP0, Num101_TOKEN, E1of2), Num101_SUBSTRING};
        this.seasonPattern = Pattern.compile("Season[-._ ]?(\\d{1,2})", 258);
    }

    protected List<SxE> single(String season, String episode) {
        return Collections.singletonList(new SxE(season, episode));
    }

    protected List<SxE> multi(String season, String ... episodes) {
        Integer s = StringUtilities.matchInteger(season);
        return Arrays.stream(episodes).flatMap(e -> StringUtilities.matchIntegers(e).stream()).map(e -> new SxE(s, (Integer)e)).collect(Collectors.toList());
    }

    protected List<SxE> range(String season, String ... episodes) {
        IntSummaryStatistics stats = Arrays.stream(episodes).flatMap(s -> StringUtilities.matchIntegers(s).stream()).mapToInt(i -> i).summaryStatistics();
        if (season == null && stats.getMax() - stats.getMin() >= 9) {
            return Collections.emptyList();
        }
        Integer s2 = StringUtilities.matchInteger(season);
        return IntStream.rangeClosed(stats.getMin(), stats.getMax()).boxed().map(e -> new SxE(s2, (Integer)e)).collect(Collectors.toList());
    }

    protected List<SxE> pairs(String text) {
        ArrayList<SxE> matches = new ArrayList<SxE>(2);
        String[] numbers = RegularExpressions.NON_DIGIT.split(text);
        for (int i = 0; i < numbers.length; i += 2) {
            matches.add(new SxE(numbers[i], numbers[i + 1]));
        }
        return matches;
    }

    protected List<SxE> numbers(String head, String ... tail) {
        SxE absolute;
        ArrayList<SxE> matches = new ArrayList<SxE>(2);
        for (String t : tail) {
            SxE sxe = new SxE(head, t);
            if (sxe.season <= 0) continue;
            matches.add(sxe);
        }
        if (tail.length == 1 && !matches.contains(absolute = new SxE(null, head + tail[0]))) {
            matches.add(absolute);
        }
        return matches;
    }

    public List<SxE> match(CharSequence name) {
        for (SeasonEpisodeParser pattern : this.patterns) {
            List<SxE> match = pattern.match(name);
            if (match.isEmpty()) continue;
            return match;
        }
        return null;
    }

    public List<SxE> match(File file) {
        List<String> tail = this.tokenizeTail(file);
        for (SeasonEpisodeParser pattern : this.patterns) {
            for (int t = 0; t < tail.size(); ++t) {
                List<SxE> match = pattern.match(tail.get(t));
                if (match.isEmpty()) continue;
                for (int i = 0; i < match.size(); ++i) {
                    Matcher sm;
                    if (match.get((int)i).season >= 0 || t >= tail.size() - 1 || !(sm = this.seasonPattern.matcher(tail.get(t + 1))).find()) continue;
                    match.set(i, new SxE(Integer.parseInt(sm.group(1)), match.get((int)i).episode));
                }
                return match;
            }
        }
        return null;
    }

    protected List<String> tokenizeTail(File file) {
        ArrayList<String> tail = new ArrayList<String>(2);
        for (File f : FileUtilities.listPathTail(file, 2, true)) {
            tail.add(FileUtilities.getName(f));
        }
        return tail;
    }

    public int find(CharSequence name, int fromIndex) {
        for (SeasonEpisodeParser pattern : this.patterns) {
            int index = pattern.find(name, fromIndex);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    public String head(String name) {
        int seasonEpisodePosition = this.find(name, 0);
        if (seasonEpisodePosition > 0) {
            return name.substring(0, seasonEpisodePosition).trim();
        }
        return null;
    }

    public static class SeasonEpisodeUnion
    implements SeasonEpisodeParser {
        private final SeasonEpisodeParser[] parsers;

        public SeasonEpisodeUnion(SeasonEpisodeParser ... parsers) {
            this.parsers = parsers;
        }

        @Override
        public List<SxE> match(CharSequence name) {
            LinkedHashSet<SxE> matches = new LinkedHashSet<SxE>();
            for (SeasonEpisodeParser it : this.parsers) {
                matches.addAll(it.match(name));
            }
            return new ArrayList<SxE>(matches);
        }

        @Override
        public int find(CharSequence name, int fromIndex) {
            int min = -1;
            for (SeasonEpisodeParser it : this.parsers) {
                int pos = it.find(name, fromIndex);
                if (pos < 0 || pos <= min) continue;
                min = pos;
            }
            return min;
        }
    }

    public static class SeasonEpisodePattern
    implements SeasonEpisodeParser {
        protected Pattern pattern;
        protected Function<MatchResult, List<SxE>> process;
        protected SeasonEpisodeFilter sanity;

        public SeasonEpisodePattern(SeasonEpisodeFilter sanity, String pattern) {
            this(sanity, pattern, m -> Collections.singletonList(new SxE(m.group(1), m.group(2))));
        }

        public SeasonEpisodePattern(SeasonEpisodeFilter sanity, String pattern, Function<MatchResult, List<SxE>> process) {
            this.pattern = Pattern.compile(pattern);
            this.process = process;
            this.sanity = sanity;
        }

        public Matcher matcher(CharSequence name) {
            return this.pattern.matcher(name);
        }

        @Override
        public List<SxE> match(CharSequence name) {
            ArrayList<SxE> matches = new ArrayList<SxE>(2);
            Matcher matcher = this.matcher(name);
            while (matcher.find()) {
                for (SxE value : this.process.apply(matcher)) {
                    if (this.sanity != null && !this.sanity.filter(value, matches)) continue;
                    matches.add(value);
                }
            }
            return matches;
        }

        @Override
        public int find(CharSequence name, int fromIndex) {
            Matcher matcher = this.matcher(name).region(fromIndex, name.length());
            while (matcher.find()) {
                for (SxE value : this.process.apply(matcher)) {
                    if (this.sanity != null && !this.sanity.filter(value)) continue;
                    return matcher.start();
                }
            }
            return -1;
        }

        public String toString() {
            return this.pattern.pattern();
        }
    }

    public static interface SeasonEpisodeParser {
        public List<SxE> match(CharSequence var1);

        public int find(CharSequence var1, int var2);
    }

    public static class SeasonEpisodeFilter {
        public final int seasonLimit;
        public final int seasonEpisodeLimit;
        public final int absoluteEpisodeLimit;
        public final int seasonYearBegin;
        public final int seasonYearEnd;

        public SeasonEpisodeFilter(int seasonLimit, int seasonEpisodeLimit, int absoluteEpisodeLimit, int seasonYearBegin, int seasonYearEnd) {
            this.seasonLimit = seasonLimit;
            this.seasonEpisodeLimit = seasonEpisodeLimit;
            this.absoluteEpisodeLimit = absoluteEpisodeLimit;
            this.seasonYearBegin = seasonYearBegin;
            this.seasonYearEnd = seasonYearEnd;
        }

        boolean filter(SxE sxe) {
            return sxe.season >= 0 && (sxe.season < this.seasonLimit || sxe.season > this.seasonYearBegin && sxe.season < this.seasonYearEnd) && sxe.episode < this.seasonEpisodeLimit || sxe.season < 0 && sxe.episode < this.absoluteEpisodeLimit;
        }

        public boolean filter(SxE value, List<SxE> sequence) {
            return this.filter(value) && sequence.stream().filter((? super T other) -> value.season == -1 == (other.season == -1) && other.compareTo(value) > 0).count() == 0L;
        }
    }

    public static class SxE
    implements Comparable<SxE> {
        public static final int UNDEFINED = -1;
        public final int season;
        public final int episode;

        public SxE(Integer season, Integer episode) {
            this.season = season != null ? season : -1;
            this.episode = episode != null ? episode : -1;
        }

        public SxE(String season, String episode) {
            this.season = this.parse(season);
            this.episode = this.parse(episode);
        }

        protected int parse(String number) {
            try {
                return Integer.parseInt(number);
            }
            catch (Exception e) {
                return -1;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof SxE) {
                SxE other = (SxE)object;
                return this.season == other.season && this.episode == other.episode;
            }
            return false;
        }

        @Override
        public int compareTo(SxE other) {
            return this.season < other.season ? -1 : (this.season != other.season ? 1 : (this.episode < other.episode ? -1 : (this.episode != other.episode ? 1 : 0)));
        }

        public int hashCode() {
            return Objects.hash(this.season, this.episode);
        }

        public String toString() {
            return this.season >= 0 ? String.format("%dx%02d", this.season, this.episode) : String.format("%02d", this.episode);
        }
    }
}

