/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.Locale;
import net.filebot.similarity.CommonSequenceMatcher;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.SimilarityMetric;

public class SequenceMatchSimilarity
implements SimilarityMetric {
    private final CommonSequenceMatcher commonSequenceMatcher;

    public SequenceMatchSimilarity() {
        this(10, false);
    }

    public SequenceMatchSimilarity(int commonSequenceMaxStartIndex, boolean returnFirstMatch) {
        this.commonSequenceMatcher = new CommonSequenceMatcher(CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH), commonSequenceMaxStartIndex, returnFirstMatch);
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        String s2;
        String s1 = this.normalize(o1);
        String match = this.match(s1, s2 = this.normalize(o2));
        if (match == null || match.isEmpty()) {
            return 0.0f;
        }
        return this.similarity(match, s1, s2);
    }

    protected float similarity(String match, String s1, String s2) {
        return (float)match.length() / (float)Math.min(s1.length(), s2.length());
    }

    protected String normalize(Object object) {
        String name = object.toString();
        name = Normalization.normalizePunctuation(name);
        return name.trim().toLowerCase();
    }

    protected String match(String s1, String s2) {
        return this.commonSequenceMatcher.matchFirstCommonSequence(s1, s2);
    }
}

