/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import java.text.CollationKey;
import java.text.Collator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.filebot.media.SmartSeasonEpisodeMatcher;
import net.filebot.similarity.CommonSequenceMatcher;
import net.filebot.similarity.DateMatcher;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;

public class SeriesNameMatcher {
    protected final SimilarityMetric metric;
    protected final SeasonEpisodeMatcher seasonEpisodeMatcher;
    protected final DateMatcher dateMatcher;
    protected final CommonSequenceMatcher commonSequenceMatcher;

    public SeriesNameMatcher(boolean strict) {
        this(new NameSimilarityMetric(), CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH), new SmartSeasonEpisodeMatcher(SeasonEpisodeMatcher.DEFAULT_SANITY, strict), new DateMatcher(DateMatcher.DEFAULT_SANITY, Locale.ENGLISH));
    }

    public SeriesNameMatcher(SeasonEpisodeMatcher seasonEpisodeMatcher, DateMatcher dateMatcher) {
        this(new NameSimilarityMetric(), CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH), seasonEpisodeMatcher, dateMatcher);
    }

    public SeriesNameMatcher(SimilarityMetric metric, Collator collator, SeasonEpisodeMatcher seasonEpisodeMatcher, DateMatcher dateMatcher) {
        this.metric = metric;
        this.seasonEpisodeMatcher = seasonEpisodeMatcher;
        this.dateMatcher = dateMatcher;
        this.commonSequenceMatcher = new CommonSequenceMatcher(collator, 3, true){

            @Override
            public CollationKey[] split(String sequence) {
                return super.split(SeriesNameMatcher.this.normalize(sequence));
            }
        };
    }

    public Collection<String> matchAll(File[] files) {
        SeriesNameCollection seriesNames = new SeriesNameCollection();
        for (Map.Entry<File, String[]> entry : this.mapNamesByFolder(files).entrySet()) {
            String parent = entry.getKey().getName();
            String[] names = entry.getValue();
            for (String nameMatch : this.matchAll(names)) {
                String commonMatch = this.commonSequenceMatcher.matchFirstCommonSequence(nameMatch, parent);
                float similarity = commonMatch == null ? 0.0f : this.metric.getSimilarity(commonMatch, nameMatch);
                seriesNames.add((double)similarity > 0.7 ? commonMatch : nameMatch);
            }
        }
        return seriesNames;
    }

    public Collection<String> matchAll(String[] names) {
        SeriesNameCollection seriesNames = new SeriesNameCollection();
        int threshold = Math.min(names.length, 5);
        SeriesNameCollection whitelist = new SeriesNameCollection();
        String[] focus = Arrays.copyOf(names, names.length);
        for (int i = 0; i < focus.length; ++i) {
            String beforeSxE = this.seasonEpisodeMatcher.head(focus[i]);
            if (beforeSxE != null && beforeSxE.length() > 0) {
                focus[i] = beforeSxE;
                continue;
            }
            int datePos = this.dateMatcher.find(focus[i], 0);
            if (datePos < 0) continue;
            focus[i] = focus[i].substring(0, datePos);
        }
        whitelist.addAll(this.deepMatchAll(focus, threshold));
        seriesNames.addAll(this.flatMatchAll(names, Pattern.compile(StringUtilities.join(whitelist, (CharSequence)"|"), 258), threshold, false));
        seriesNames.addAll(whitelist);
        return seriesNames;
    }

    private Collection<String> flatMatchAll(String[] names, Pattern prefixPattern, int threshold, boolean strict) {
        Collator wordComparator = this.commonSequenceMatcher.getCollator();
        ThresholdCollection<Object> thresholdCollection = new ThresholdCollection<Object>(threshold, wordComparator);
        for (String name : names) {
            Matcher prefix = prefixPattern.matcher(name = this.normalize(name));
            int prefixEnd = prefix.find() ? prefix.end() : 0;
            int sxePosition = this.seasonEpisodeMatcher.find(name, prefixEnd);
            if (sxePosition > 0) {
                String hit = name.substring(0, sxePosition).trim();
                List<SeasonEpisodeMatcher.SxE> sxe = this.seasonEpisodeMatcher.match(name.substring(sxePosition));
                if (!strict && sxe.size() == 1 && sxe.get((int)0).season >= 0) {
                    thresholdCollection.addDirect(hit);
                    continue;
                }
                thresholdCollection.add(hit);
                continue;
            }
            int datePosition = this.dateMatcher.find(name, prefixEnd);
            if (datePosition <= 0) continue;
            thresholdCollection.addDirect(name.substring(0, datePosition).trim());
        }
        return thresholdCollection;
    }

    private Collection<String> deepMatchAll(String[] names, int threshold) {
        if (names.length < 2 || names.length < threshold) {
            return Collections.emptySet();
        }
        String common = this.commonSequenceMatcher.matchFirstCommonSequence(names);
        if (common != null) {
            return Collections.singleton(common);
        }
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.deepMatchAll(Arrays.copyOfRange(names, 0, names.length / 2), threshold));
        results.addAll(this.deepMatchAll(Arrays.copyOfRange(names, names.length / 2, names.length), threshold));
        return results;
    }

    public String matchByEpisodeIdentifier(String name) {
        String seriesName = this.seasonEpisodeMatcher.head(name);
        if (seriesName != null && seriesName.length() > 0) {
            return seriesName;
        }
        int datePosition = this.dateMatcher.find(name, 0);
        if (datePosition > 0) {
            return name.substring(0, datePosition);
        }
        return null;
    }

    public String matchBySeparator(String name) {
        Pattern separator = Pattern.compile("[\\s]+[-]+[\\s]+", 256);
        Matcher matcher = separator.matcher(name);
        if (matcher.find() && matcher.start() > 0) {
            return Normalization.normalizePunctuation(name.substring(0, matcher.start()));
        }
        return null;
    }

    public String matchByFirstCommonWordSequence(String ... names) {
        if (names.length < 2) {
            throw new IllegalArgumentException("Can't match common sequence from less than two names");
        }
        return this.commonSequenceMatcher.matchFirstCommonSequence(names);
    }

    protected String normalize(String name) {
        return Normalization.normalizePunctuation(Normalization.normalizeBrackets(name));
    }

    protected <T> T[] firstCommonSequence(T[] seq1, T[] seq2, int maxStartIndex, Comparator<T> equalsComparator) {
        for (int i = 0; i < seq1.length && i <= maxStartIndex; ++i) {
            for (int j = 0; j < seq2.length && j <= maxStartIndex; ++j) {
                int len = 0;
                while (i + len < seq1.length && j + len < seq2.length && equalsComparator.compare(seq1[i + len], seq2[j + len]) == 0) {
                    ++len;
                }
                if (len <= 0) continue;
                if (i == 0 && len == seq1.length) {
                    return seq1;
                }
                return Arrays.copyOfRange(seq1, i, i + len);
            }
        }
        return null;
    }

    private Map<File, String[]> mapNamesByFolder(File ... files) {
        LinkedHashMap<File, ArrayList<File>> filesByFolder = new LinkedHashMap<File, ArrayList<File>>();
        for (File file : files) {
            File folder = file.getParentFile();
            ArrayList<File> list = (ArrayList<File>)filesByFolder.get(folder);
            if (list == null) {
                list = new ArrayList<File>();
                filesByFolder.put(folder, list);
            }
            list.add(file);
        }
        LinkedHashMap<File, String[]> namesByFolder = new LinkedHashMap<File, String[]>();
        for (Map.Entry entry : filesByFolder.entrySet()) {
            namesByFolder.put((File)entry.getKey(), this.names((Collection)entry.getValue()));
        }
        return namesByFolder;
    }

    protected String[] names(Collection<File> files) {
        String[] names = new String[files.size()];
        int i = 0;
        for (File file : files) {
            names[i++] = FileUtilities.getName(file);
        }
        return names;
    }

    protected static class ThresholdCollection<E>
    extends AbstractCollection<E> {
        private final Collection<E> heaven = new ArrayList();
        private final Map<E, Collection<E>> limbo;
        private final int threshold;

        public ThresholdCollection(int threshold, Comparator<E> equalityComparator) {
            this.limbo = new TreeMap<E, Collection<E>>(equalityComparator);
            this.threshold = threshold;
        }

        @Override
        public boolean add(E value) {
            Collection<E> buffer = this.limbo.get(value);
            if (buffer == null) {
                buffer = new ArrayList(this.threshold);
                this.limbo.put(value, buffer);
            }
            if (buffer == this.heaven) {
                this.heaven.add(value);
                return true;
            }
            buffer.add(value);
            if (buffer.size() >= this.threshold) {
                this.heaven.addAll(buffer);
                this.limbo.put(value, this.heaven);
                return true;
            }
            return false;
        }

        public boolean addDirect(E element) {
            return this.heaven.add(element);
        }

        @Override
        public Iterator<E> iterator() {
            return this.heaven.iterator();
        }

        @Override
        public int size() {
            return this.heaven.size();
        }
    }

    protected static class SeriesNameCollection
    extends AbstractCollection<String> {
        private final Map<String, String> data = new LinkedHashMap<String, String>();

        protected SeriesNameCollection() {
        }

        @Override
        public boolean add(String value) {
            if ((value = value.trim()).length() < 2) {
                return false;
            }
            String current = this.data.get(this.key(value));
            if (current == null || this.firstCharacterCaseBalance(current) < this.firstCharacterCaseBalance(value)) {
                this.data.put(this.key(value), value);
                return true;
            }
            return false;
        }

        protected String key(Object value) {
            return value.toString().toLowerCase();
        }

        protected float firstCharacterCaseBalance(String s) {
            int upper = 0;
            int lower = 0;
            Scanner scanner = new Scanner(s);
            while (scanner.hasNext()) {
                char c = scanner.next().charAt(0);
                if (Character.isLowerCase(c)) {
                    ++lower;
                    continue;
                }
                if (!Character.isUpperCase(c)) continue;
                ++upper;
            }
            return ((float)lower + (float)upper * 1.01f) / (float)Math.abs(lower - upper);
        }

        @Override
        public boolean contains(Object value) {
            return this.data.containsKey(this.key(value));
        }

        @Override
        public Iterator<String> iterator() {
            return this.data.values().iterator();
        }

        @Override
        public int size() {
            return this.data.size();
        }
    }
}

