/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import net.filebot.similarity.Normalization;
import net.filebot.similarity.SimilarityMetric;

public class SubstringMetric
implements SimilarityMetric {
    private boolean o1c2;
    private boolean o2c1;

    public SubstringMetric() {
        this(true, true);
    }

    public SubstringMetric(boolean o2c1, boolean o1c2) {
        this.o1c2 = o1c2;
        this.o2c1 = o2c1;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        String s1 = this.normalize(o1);
        if (s1 == null || s1.isEmpty()) {
            return 0.0f;
        }
        String s2 = this.normalize(o2);
        if (s2 == null || s2.isEmpty()) {
            return 0.0f;
        }
        return this.o1c2 && this.matches(s1, s2) || this.o2c1 && this.matches(s2, s1) ? 1.0f : 0.0f;
    }

    protected boolean matches(String s1, String s2) {
        int index = s1.lastIndexOf(s2);
        if (index < 0) {
            return false;
        }
        if (index - 1 >= 0 && Character.isLetterOrDigit(s1.charAt(index - 1))) {
            return false;
        }
        return index + s2.length() >= s1.length() || !Character.isLetterOrDigit(s1.charAt(index + s2.length()));
    }

    protected String normalize(Object object) {
        if (object == null) {
            return null;
        }
        String name = object.toString();
        name = Normalization.normalizePunctuation(name);
        return name.trim().toLowerCase();
    }
}

