/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.filebot.subtitle.SubtitleElement;
import net.filebot.subtitle.SubtitleReader;
import net.filebot.util.StringUtilities;

public class SubRipReader
extends SubtitleReader {
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss,SSS", Locale.ROOT);
    private final Pattern tag;

    public SubRipReader(Scanner scanner) {
        super(scanner);
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.tag = Pattern.compile("</?(b|u|i|font[^<>]*)>", 2);
    }

    @Override
    protected SubtitleElement readNext() throws Exception {
        String number = this.scanner.nextLine();
        if (!number.matches("\\d+")) {
            return null;
        }
        String[] interval = this.scanner.nextLine().split("-->", 2);
        if (interval.length < 2) {
            return null;
        }
        long t1 = this.timeFormat.parse(interval[0].trim()).getTime();
        long t2 = this.timeFormat.parse(interval[1].trim()).getTime();
        ArrayList<String> lines = new ArrayList<String>(2);
        String line = this.scanner.nextLine();
        while (line.length() > 0) {
            lines.add(line);
            line = this.scanner.hasNextLine() ? this.scanner.nextLine() : "";
        }
        return new SubtitleElement(t1, t2, this.resolve(StringUtilities.join(lines, (CharSequence)"\n")));
    }

    protected String resolve(String text) {
        return this.tag.matcher(text).replaceAll("").trim();
    }
}

