/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

class SubtitleTimeFormat
extends DateFormat {
    private final Pattern delimiter = Pattern.compile("[:.]");

    public SubtitleTimeFormat() {
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer sb, FieldPosition pos) {
        this.calendar.setTime(date);
        sb.append(String.format("%02d", this.calendar.get(11)));
        sb.append(':').append(String.format("%02d", this.calendar.get(12)));
        sb.append(':').append(String.format("%02d", this.calendar.get(13)));
        String millis = String.format("%03d", this.calendar.get(14));
        sb.append('.').append(millis.substring(0, 2));
        return sb;
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        String[] split = this.delimiter.split(source, 4);
        this.calendar.clear();
        try {
            this.calendar.set(11, Integer.parseInt(split[0]));
            this.calendar.set(12, Integer.parseInt(split[1]));
            this.calendar.set(13, Integer.parseInt(split[2]));
            this.calendar.set(14, Integer.parseInt(split[3]) * 10);
        }
        catch (Exception e) {
            pos.setErrorIndex(0);
            return null;
        }
        pos.setIndex(source.length());
        return this.calendar.getTime();
    }
}

