/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.torrent;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.filebot.torrent.BDecoder;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.SimpleFileInfo;

public class Torrent {
    private String name;
    private String encoding;
    private String createdBy;
    private String announce;
    private String comment;
    private Long creationDate;
    private Long pieceLength;
    private List<FileInfo> files;
    private boolean singleFileTorrent;

    protected Torrent() {
    }

    public Torrent(File torrent) throws IOException {
        this(Torrent.decodeTorrent(torrent));
    }

    public Torrent(Map<?, ?> torrentMap) {
        Charset charset = StandardCharsets.UTF_8;
        this.encoding = this.decodeString(torrentMap.get("encoding"), charset);
        try {
            charset = Charset.forName(this.encoding);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.createdBy = this.decodeString(torrentMap.get("created by"), charset);
        this.announce = this.decodeString(torrentMap.get("announce"), charset);
        this.comment = this.decodeString(torrentMap.get("comment"), charset);
        this.creationDate = this.decodeLong(torrentMap.get("creation date"));
        Map infoMap = (Map)torrentMap.get("info");
        this.name = this.decodeString(infoMap.get("name"), charset);
        this.pieceLength = (Long)infoMap.get("piece length");
        if (infoMap.containsKey("files")) {
            this.singleFileTorrent = false;
            ArrayList<SimpleFileInfo> entries = new ArrayList<SimpleFileInfo>();
            for (Object fileMapObject : (List)infoMap.get("files")) {
                Map fileMap = (Map)fileMapObject;
                List pathList = (List)fileMap.get("path");
                StringBuilder path = new StringBuilder(80);
                Iterator iterator = pathList.iterator();
                while (iterator.hasNext()) {
                    path.append(this.decodeString(iterator.next(), charset));
                    if (!iterator.hasNext()) continue;
                    path.append("/");
                }
                Long length = this.decodeLong(fileMap.get("length"));
                entries.add(new SimpleFileInfo(path.toString(), length));
            }
            this.files = Collections.unmodifiableList(entries);
        } else {
            this.singleFileTorrent = true;
            Long length = this.decodeLong(infoMap.get("length"));
            this.files = Collections.singletonList(new SimpleFileInfo(this.name, length));
        }
    }

    private static Map<?, ?> decodeTorrent(File torrent) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(torrent));){
            Map<?, ?> map = BDecoder.decode(in);
            return map;
        }
    }

    private String decodeString(Object byteArray, Charset charset) {
        if (byteArray == null) {
            return null;
        }
        return new String((byte[])byteArray, charset);
    }

    private Long decodeLong(Object number) {
        if (number == null) {
            return null;
        }
        return (Long)number;
    }

    public String getAnnounce() {
        return this.announce;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public String getName() {
        return this.name;
    }

    public Long getPieceLength() {
        return this.pieceLength;
    }

    public boolean isSingleFileTorrent() {
        return this.singleFileTorrent;
    }
}

