/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import net.filebot.ui.FileBotList;
import net.filebot.ui.transfer.ClipboardHandler;
import net.filebot.ui.transfer.TextFileExportHandler;

public class FileBotListExportHandler<T>
extends TextFileExportHandler
implements ClipboardHandler {
    protected final FileBotList<T> list;
    protected final BiConsumer<T, PrintWriter> exportItem;

    public FileBotListExportHandler(FileBotList<T> list) {
        this(list, (item, out) -> out.println(item));
    }

    public FileBotListExportHandler(FileBotList<T> list, BiConsumer<T, PrintWriter> exportItem) {
        this.list = list;
        this.exportItem = exportItem;
    }

    @Override
    public boolean canExport() {
        return this.list.getModel().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(PrintWriter out) {
        try {
            this.list.setCursor(Cursor.getPredefinedCursor(3));
            for (Object item : this.list.getModel()) {
                this.exportItem.accept(item, out);
            }
        }
        finally {
            this.list.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public String getDefaultFileName() {
        return this.list.getTitle() + ".txt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToClipboard(JComponent c, Clipboard clip, int action) throws IllegalStateException {
        StringWriter buffer = new StringWriter();
        try (PrintWriter out = new PrintWriter(buffer);){
            this.list.setCursor(Cursor.getPredefinedCursor(3));
            for (T item : this.list.getListComponent().getSelectedValuesList()) {
                this.exportItem.accept(item, out);
            }
        }
        finally {
            this.list.setCursor(Cursor.getDefaultCursor());
        }
        clip.setContents(new StringSelection(buffer.toString()), null);
    }
}

