/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import com.sun.webkit.WebPage;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.util.ui.SwingUI;

public class GettingStartedStage {
    private Stage stage;

    public static void start() {
        SwingUI.invokeJavaFX(() -> {
            if (Settings.isMacSandbox()) {
                GettingStartedStage.ask();
            } else {
                GettingStartedStage.create().show();
            }
        });
    }

    private static void ask() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("FileBot");
        alert.setHeaderText("Hello! Do you need help Getting Started?");
        alert.setContentText("If you have never used FileBot before, please have a look at the video tutorials first.");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            SwingUI.openURI(Settings.getEmbeddedHelpURL());
        }
    }

    private static GettingStartedStage create() {
        Stage stage = new Stage();
        stage.setResizable(false);
        if (Settings.isWindowsApp()) {
            stage.getIcons().setAll((Object[])ResourceManager.getApplicationIconResources().map(URL::toString).map(Image::new).toArray(Image[]::new));
            stage.initStyle(StageStyle.DECORATED);
            stage.initModality(Modality.NONE);
        } else {
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.NONE);
        }
        return new GettingStartedStage(stage);
    }

    public GettingStartedStage(Stage stage) {
        this.stage = stage;
        WebView webview = new WebView();
        webview.getEngine().load(Settings.getEmbeddedHelpURL());
        webview.setPrefSize(750.0, 490.0);
        webview.getEngine().setCreatePopupHandler(config -> this.onPopup(webview));
        webview.getEngine().getLoadWorker().stateProperty().addListener((v, o, n) -> {
            if (n == Worker.State.SUCCEEDED) {
                stage.setTitle(webview.getEngine().getTitle());
                stage.toFront();
                webview.requestFocus();
            } else if (n == Worker.State.FAILED) {
                stage.close();
            }
        });
        stage.setTitle("Loading \u2026");
        stage.setScene(new Scene((Parent)webview, webview.getPrefWidth(), webview.getPrefHeight(), (Paint)Color.BLACK));
        this.setBackground(webview.getEngine(), -16777216);
        webview.getEngine().executeScript(String.format("navigator.locale = '%s'", Locale.getDefault()));
    }

    public void show() {
        this.stage.setOpacity(0.0);
        this.stage.show();
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)1.0, Interpolator.EASE_IN)})});
        timeline.setOnFinished(evt -> {
            this.stage.setOpacity(1.0);
            this.stage.requestFocus();
        });
        timeline.play();
    }

    protected void setBackground(WebEngine engine, int color) {
        try {
            Field f = engine.getClass().getDeclaredField("page");
            f.setAccessible(true);
            WebPage page = (WebPage)f.get(engine);
            page.setBackgroundColor(color);
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, "Failed to set background", e);
        }
    }

    protected WebEngine onPopup(WebView webview) {
        Object uri = webview.getEngine().executeScript("$('.galleria').data('galleria').getData().link");
        SwingUI.openURI(uri.toString());
        return null;
    }
}

