/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.filebot.ResourceManager;
import net.filebot.util.ui.DefaultFancyListCellRenderer;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.SearchResult;
import net.miginfocom.swing.MigLayout;

public class SelectDialog<T>
extends JDialog {
    private JLabel messageLabel = new JLabel();
    private JCheckBox autoRepeatCheckBox = new JCheckBox();
    private JList<T> list;
    private String command = null;
    public static final String SELECT = "Select";
    public static final String CANCEL = "Cancel";
    private final Action selectAction = SwingUI.newAction("Select", ResourceManager.getIcon("dialog.continue"), evt -> {
        this.command = SELECT;
        this.close();
    });
    private final Action cancelAction = SwingUI.newAction("Cancel", ResourceManager.getIcon("dialog.cancel"), evt -> {
        this.command = CANCEL;
        this.close();
    });
    private final MouseAdapter mouseListener = SwingUI.mouseClicked(evt -> {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            this.selectAction.actionPerformed(new ActionEvent(evt.getSource(), 1001, SELECT));
        }
    });
    private static final String KEY_REPEAT = "dialog.select.repeat";
    private static final String KEY_WIDTH = "dialog.select.width";
    private static final String KEY_HEIGHT = "dialog.select.height";

    public SelectDialog(Component parent, Collection<? extends T> options) {
        this(parent, options, false, false, null);
    }

    public SelectDialog(Component parent, Collection<? extends T> options, boolean autoRepeatEnabled, boolean autoRepeatSelected, JComponent header) {
        super(SwingUI.getWindow(parent), SELECT, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.list = new JList<Object>(options.toArray());
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        DefaultFancyListCellRenderer renderer = new DefaultFancyListCellRenderer(4){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, SelectDialog.this.convertValueToString(value), index, isSelected, cellHasFocus);
                SelectDialog.this.configureValue(this, value);
                return this;
            }
        };
        renderer.setHighlightingEnabled(false);
        this.list.setCellRenderer(renderer);
        this.list.addMouseListener(this.mouseListener);
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new MigLayout("insets 1.5mm 1.5mm 2.7mm 1.5mm, nogrid, novisualpadding, fill", "", header == null ? "[pref!][fill][pref!]" : "[min!][min!][fill][pref!]"));
        if (header != null) {
            c.add((Component)header, "wmin 150px, hmin pref, growx, wrap");
        }
        c.add((Component)this.messageLabel, "wmin 150px, hmin pref, growx, wrap");
        c.add((Component)new JScrollPane(this.list), "wmin 150px, hmin 150px, grow, wrap 2mm");
        c.add((Component)new JButton(this.selectAction), "align center, id select");
        c.add((Component)new JButton(this.cancelAction), "gap unrel, id cancel");
        if (autoRepeatEnabled) {
            this.autoRepeatCheckBox.addChangeListener(evt -> this.autoRepeatCheckBox.setToolTipText(this.autoRepeatCheckBox.isSelected() ? "Select and remember for next time" : "Select once and ask again next time"));
            this.autoRepeatCheckBox.setCursor(Cursor.getPredefinedCursor(12));
            this.autoRepeatCheckBox.setIcon(ResourceManager.getIcon("button.repeat"));
            this.autoRepeatCheckBox.setSelectedIcon(ResourceManager.getIcon("button.repeat.selected"));
            this.autoRepeatCheckBox.setSelected(autoRepeatSelected);
            c.add((Component)this.autoRepeatCheckBox, "pos 1al select.y n select.y2");
        }
        this.setMinimumSize(new Dimension(400, 330));
        SwingUI.installAction(this.list, KeyStroke.getKeyStroke(10, 0), this.selectAction);
    }

    protected String convertValueToString(Object value) {
        return value.toString();
    }

    protected void configureValue(DefaultFancyListCellRenderer render, Object value) {
        if (value instanceof SearchResult) {
            render.setToolTipText(this.getTooltipText((SearchResult)value));
        } else if (value instanceof File) {
            render.setToolTipText(((File)value).getAbsolutePath());
        } else {
            render.setToolTipText(null);
        }
    }

    protected String getTooltipText(SearchResult item) {
        StringBuilder html = new StringBuilder(64);
        html.append("<html><b>").append(SwingUI.escapeHTML(item.toString())).append("</b><br>");
        String[] names = item.getAliasNames();
        if (names.length > 0) {
            html.append("<br>AKA:<br>");
            for (String n : names) {
                html.append("\u2022 ").append(SwingUI.escapeHTML(n)).append("<br>");
            }
        }
        html.append("<br>ID: <br>\u2022 ").append(Integer.toString(item.getId())).append("</html>");
        return html.toString();
    }

    public JLabel getMessageLabel() {
        return this.messageLabel;
    }

    public JCheckBox getAutoRepeatCheckBox() {
        return this.autoRepeatCheckBox;
    }

    public String getSelectedAction() {
        return this.command;
    }

    public T getSelectedValue() {
        return SELECT.equals(this.command) ? (T)this.list.getSelectedValue() : null;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public Action getSelectAction() {
        return this.selectAction;
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public void saveState(Preferences prefs) {
        prefs.putBoolean(KEY_REPEAT, this.autoRepeatCheckBox.isSelected());
        prefs.putInt(KEY_WIDTH, this.getWidth());
        prefs.putInt(KEY_HEIGHT, this.getHeight());
    }

    public void restoreState(Preferences prefs) {
        this.autoRepeatCheckBox.setSelected(prefs.getBoolean(KEY_REPEAT, this.autoRepeatCheckBox.isSelected()));
        this.setSize(prefs.getInt(KEY_WIDTH, this.getWidth()), prefs.getInt(KEY_HEIGHT, this.getHeight()));
    }
}

