/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.filebot.ResourceManager;
import net.filebot.ui.filter.FileTree;
import net.filebot.ui.filter.FileTreeTransferablePolicy;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.ui.transfer.LoadAction;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.ui.LoadingOverlayPane;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

class FileTreePanel
extends JComponent {
    private FileTree fileTree = new FileTree();
    private FileTreeTransferablePolicy transferablePolicy = new FileTreeTransferablePolicy(this.fileTree);
    private final LoadAction loadAction = new LoadAction(this::getTransferablePolicy);
    private final Action clearAction = SwingUI.newAction("Clear", ResourceManager.getIcon("action.clear"), evt -> {
        this.transferablePolicy.reset();
        this.fileTree.clear();
        this.fireFileTreeChange();
    });
    public static final String FILE_TREE_PROPERTY = "FILE_TREE";

    public FileTreePanel() {
        this.fileTree.setTransferHandler(new DefaultTransferHandler(this.transferablePolicy, null));
        this.setBorder(BorderFactory.createTitledBorder("File Tree"));
        this.setLayout(new MigLayout("insets 0, nogrid, fill", "align center", "[fill][pref!]"));
        this.add((Component)new LoadingOverlayPane(new JScrollPane(this.fileTree), this), "grow, wrap 1.2mm");
        this.add(new JButton(this.loadAction));
        this.add((Component)new JButton(this.clearAction), "gap 1.2mm, wrap 1.2mm");
        this.transferablePolicy.addPropertyChangeListener(evt -> {
            if ("loading".equals(evt.getPropertyName())) {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.transferablePolicy.addPropertyChangeListener(evt -> {
            if ("loading".equals(evt.getPropertyName()) && !((Boolean)evt.getNewValue()).booleanValue()) {
                this.fireFileTreeChange();
            }
        });
    }

    public FileTree getFileTree() {
        return this.fileTree;
    }

    public TransferablePolicy getTransferablePolicy() {
        return this.transferablePolicy;
    }

    private void fireFileTreeChange() {
        this.firePropertyChange(FILE_TREE_PROPERTY, null, this.fileTree);
    }
}

