/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.filter.FileTree;
import net.filebot.ui.transfer.BackgroundFileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FastFile;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;

class FileTreeTransferablePolicy
extends BackgroundFileTransferablePolicy<TreeNode> {
    private final FileTree tree;

    public FileTreeTransferablePolicy(FileTree tree) {
        this.tree = tree;
    }

    @Override
    protected boolean accept(List<File> files) {
        return true;
    }

    @Override
    protected void clear() {
        super.clear();
        this.tree.clear();
    }

    @Override
    protected void process(List<TreeNode> root) {
        this.tree.getModel().setRoot(new FileTree.FolderNode(root));
        this.tree.getModel().reload();
    }

    @Override
    protected void process(Exception e) {
        Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e), e);
    }

    @Override
    protected void load(List<File> files, TransferablePolicy.TransferAction action) {
        if (Settings.isMacSandbox()) {
            MacAppUtilities.askUnlockFolders(SwingUI.getWindow(this.tree), files);
        }
        try {
            TreeNode[] node = (TreeNode[])files.stream().map(FastFile::new).map(this::getTreeNode).toArray(TreeNode[]::new);
            this.publish(node);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    private TreeNode getTreeNode(File file) {
        if (Thread.interrupted()) {
            throw new CancellationException();
        }
        if (file.isDirectory()) {
            LinkedList<TreeNode> children = new LinkedList<TreeNode>();
            for (File f : FileUtilities.getChildren(file, FileUtilities.NOT_HIDDEN, FileUtilities.HUMAN_NAME_ORDER)) {
                if (f.isDirectory()) {
                    children.addFirst(this.getTreeNode(f));
                    continue;
                }
                children.addLast(this.getTreeNode(f));
            }
            return new FileTree.FolderNode(file, FileUtilities.getFolderName(file), new ArrayList<TreeNode>(children));
        }
        return new FileTree.FileNode(file);
    }

    @Override
    public String getFileFilterDescription() {
        return "Folders";
    }

    @Override
    public List<String> getFileFilterExtensions() {
        return null;
    }
}

