/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.tree.TreeNode;
import net.filebot.Logging;
import net.filebot.ui.filter.FileTree;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;

abstract class Tool<M>
extends JComponent {
    private List<File> root = Collections.emptyList();
    private UpdateModelTask updateTask;

    public Tool(String name) {
        this.setName(name);
    }

    public List<File> getRoot() {
        return this.root;
    }

    public void setRoot(List<File> root) {
        this.root = root;
        if (this.updateTask != null) {
            this.updateTask.cancel(true);
        }
        this.setLoading(true);
        this.updateTask = new UpdateModelTask(root);
        this.updateTask.execute();
    }

    protected void setLoading(boolean loading) {
        this.firePropertyChange("loading", !loading, loading);
    }

    protected abstract M createModelInBackground(List<File> var1) throws Exception;

    protected abstract void setModel(M var1);

    protected List<TreeNode> createFileNodes(Collection<File> files) {
        return files.stream().map(FileTree.FileNode::new).collect(Collectors.toList());
    }

    protected FileTree.FolderNode createStatisticsNode(String name, List<File> files) {
        List<File> selection = FileUtilities.listFiles(files, FileUtilities.FILES, null);
        long size = selection.stream().mapToLong(File::length).sum();
        String title = String.format("%s (%,d %s, %s)", name, selection.size(), selection.size() == 1 ? "file" : "files", FileUtilities.formatSize(size));
        return new FileTree.FolderNode(title, this.createFileNodes(files));
    }

    private class UpdateModelTask
    extends SwingWorker<M, Void> {
        private final List<File> root;

        public UpdateModelTask(List<File> root) {
            this.root = root;
        }

        @Override
        protected M doInBackground() throws Exception {
            return Tool.this.createModelInBackground(this.root);
        }

        @Override
        protected void done() {
            block4: {
                if (this == Tool.this.updateTask) {
                    Tool.this.setLoading(false);
                }
                if (this != Tool.this.updateTask || this.isCancelled()) break block4;
                try {
                    Tool.this.setModel(this.get());
                }
                catch (Exception e) {
                    block6: {
                        block5: {
                            Throwable cause = ExceptionUtilities.getRootCause(e);
                            if (cause instanceof InterruptedException) break block5;
                            if (!(cause instanceof CancellationException)) break block6;
                        }
                        Logging.debug.log(Level.FINEST, e, e::toString);
                    }
                    Logging.debug.log(Level.WARNING, e, e::toString);
                }
            }
        }
    }
}

