/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.media.MediaDetection;
import net.filebot.ui.transfer.BackgroundFileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FastFile;
import net.filebot.util.FileUtilities;

class FilesListTransferablePolicy
extends BackgroundFileTransferablePolicy<File> {
    private final List<File> model;

    public FilesListTransferablePolicy(List<File> model) {
        this.model = model;
    }

    @Override
    protected boolean accept(List<File> files) {
        return true;
    }

    @Override
    protected void clear() {
        this.model.clear();
    }

    @Override
    public void handleTransferable(Transferable tr, TransferablePolicy.TransferAction action) throws Exception {
        if (action == TransferablePolicy.TransferAction.LINK || action == TransferablePolicy.TransferAction.PUT) {
            this.clear();
        }
        super.handleTransferable(tr, action);
    }

    @Override
    protected void load(List<File> files, TransferablePolicy.TransferAction action) {
        LinkedHashSet<File> sink = new LinkedHashSet<File>(64, 4.0f);
        this.load(files, action != TransferablePolicy.TransferAction.LINK, sink);
        this.publish(sink.stream().map(FastFile::new).toArray(File[]::new));
    }

    private void load(List<File> files, boolean recursive, Collection<File> sink) {
        for (File f : files) {
            if (recursive && MediaTypes.LIST_FILES.accept(f)) {
                try {
                    List<File> paths = FileUtilities.readLines(f).stream().filter(s -> s.length() > 0).map(path -> {
                        try {
                            File file = new File((String)path);
                            return file.isAbsolute() && file.exists() ? file : null;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    if (paths.isEmpty()) {
                        sink.add(f);
                        continue;
                    }
                    this.load(paths, false, sink);
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, "Failed to read paths from text file: " + e.getMessage());
                }
                continue;
            }
            if (!recursive || f.isFile() || MediaDetection.isDiskFolder(f)) {
                sink.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.load(FileUtilities.getChildren(f, FileUtilities.NOT_HIDDEN, FileUtilities.HUMAN_NAME_ORDER), true, sink);
        }
    }

    @Override
    public String getFileFilterDescription() {
        return "Files and Folders";
    }

    @Override
    public List<String> getFileFilterExtensions() {
        return FileUtilities.ExtensionFileFilter.WILDCARD;
    }

    @Override
    protected void process(List<File> chunks) {
        this.model.addAll(chunks);
    }

    @Override
    protected void process(Exception e) {
        Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e), e);
    }
}

