/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.util.Map;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.MatchFormatter;
import net.filebot.util.FileUtilities;
import net.filebot.web.Movie;
import net.filebot.web.MoviePart;

class MovieFormatter
implements MatchFormatter {
    MovieFormatter() {
    }

    @Override
    public boolean canFormat(Match<?, ?> match) {
        return match.getValue() instanceof Movie;
    }

    @Override
    public String preview(Match<?, ?> match) {
        MoviePart part;
        Movie movie = (Movie)match.getValue();
        StringBuilder name = new StringBuilder();
        name.append(movie.getName()).append(" (").append(movie.getYear()).append(")");
        if (movie instanceof MoviePart && (part = (MoviePart)movie).getPartCount() > 1) {
            name.append(".CD").append(part.getPartIndex());
        }
        return FileUtilities.replacePathSeparators(name);
    }

    @Override
    public String format(Match<?, ?> match, boolean extension, Map<?, ?> context) {
        return this.preview(match);
    }
}

