/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.mediainfo.ImageMetadata;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.util.FileUtilities;
import net.filebot.web.Datasource;
import net.filebot.web.SortOrder;

public class PhotoFileMatcher
implements Datasource,
AutoCompleteMatcher {
    public static final PhotoFileMatcher INSTANCE = new PhotoFileMatcher();

    @Override
    public String getIdentifier() {
        return "exif";
    }

    @Override
    public String getName() {
        return "Exif Metadata";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.exif");
    }

    @Override
    public List<Match<File, ?>> match(Collection<File> files, boolean strict, SortOrder order, Locale locale, boolean autodetection, Component parent) throws Exception {
        ArrayList matches = new ArrayList();
        for (File f : FileUtilities.filter(files, ImageMetadata.SUPPORTED_FILE_TYPES)) {
            try {
                ImageMetadata metadata = new ImageMetadata(f);
                if (!metadata.getDateTaken().isPresent()) continue;
                matches.add(new Match<File, File>(f, f));
            }
            catch (Exception e) {
                Logging.debug.warning(Logging.format("%s [%s]", e, f));
            }
        }
        return matches;
    }
}

