/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.RenameAction;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.StandardRenameAction;
import net.filebot.UserFiles;
import net.filebot.WebServices;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.ExpressionFilter;
import net.filebot.format.MediaBindingBean;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.HeaderPanel;
import net.filebot.ui.rename.BindingDialog;
import net.filebot.ui.rename.FormatDialog;
import net.filebot.ui.rename.Preset;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Datasource;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.SortOrder;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class PresetEditor
extends JDialog {
    private Result result = Result.CANCEL;
    private HeaderPanel presetNameHeader;
    private JTextField pathInput;
    private RSyntaxTextArea filterEditor;
    private RSyntaxTextArea formatEditor;
    private JComboBox<RenameAction> actionCombo;
    private JComboBox<Datasource> providerCombo;
    private JComboBox<SortOrder> sortOrderCombo;
    private JComboBox<String> matchModeCombo;
    private JComboBox<Language> languageCombo;
    private JRadioButton selectRadio;
    private JRadioButton inheritRadio;
    private JPanel inputPanel;
    private final Action selectInputFolder = SwingUI.newAction("Select Input Folder", ResourceManager.getIcon("action.load"), evt -> {
        File f = UserFiles.showOpenDialogSelectFolder(null, "Select Input Folder", evt);
        if (f != null) {
            this.pathInput.setText(f.getAbsolutePath());
        }
    });
    private final Action editFormatExpression = SwingUI.newAction("Open Format Editor", ResourceManager.getIcon("action.format"), evt -> {
        FormatDialog.Mode mode = FormatDialog.Mode.getMode((Datasource)this.providerCombo.getSelectedItem());
        Object sample = mode.getDefaultSampleObject();
        File file = null;
        if (mode == FormatDialog.Mode.File) {
            List<File> files = UserFiles.showLoadDialogSelectFiles(false, false, null, new FileUtilities.ExtensionFileFilter(FileUtilities.ExtensionFileFilter.WILDCARD), "Select Sample File", evt);
            if (files.isEmpty()) {
                return;
            }
            file = files.get(0);
            sample = file;
        }
        FormatDialog dialog = new FormatDialog(SwingUI.getWindow(evt.getSource()), mode, new MediaBindingBean(sample, file, Collections.singletonMap(file, sample)), false);
        dialog.setFormatCode(this.formatEditor.getText());
        dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
        dialog.setVisible(true);
        if (dialog.submit()) {
            this.formatEditor.setText(dialog.getFormat().getExpression());
        }
    });
    private final Action listFiles = SwingUI.newAction("List Files", ResourceManager.getIcon("action.search"), evt -> SwingUI.withWaitCursor(evt.getSource(), () -> {
        try {
            Preset preset = this.getPreset();
            if (preset.getInputFolder() == null) {
                return;
            }
            if (Settings.isMacSandbox() && !MacAppUtilities.askUnlockFolders(SwingUI.getWindow(evt.getSource()), Collections.singleton(preset.getInputFolder()))) {
                return;
            }
            List<File> files = preset.selectFiles();
            JPopupMenu popup = new JPopupMenu();
            if (files.size() > 0) {
                for (File f : files) {
                    popup.add(SwingUI.newAction(f.getPath(), e -> {
                        BindingDialog dialog = new BindingDialog(SwingUI.getWindow(evt.getSource()), "File Bindings", FormatDialog.Mode.File.getFormat(), false);
                        dialog.setLocation(SwingUI.getOffsetLocation(SwingUI.getWindow(evt.getSource())));
                        dialog.setSample(new MediaBindingBean(f, f));
                        dialog.setVisible(true);
                    }));
                }
            } else {
                popup.add("No files selected").setEnabled(false);
            }
            JComponent source = (JComponent)evt.getSource();
            popup.show(source, -3, source.getHeight() + 4);
        }
        catch (Exception e2) {
            Logging.log.log(Level.WARNING, "Invalid preset settings: " + e2.getMessage(), e2);
        }
    }));
    private final Action ok = SwingUI.newAction("Save Preset", ResourceManager.getIcon("dialog.continue"), evt -> {
        try {
            Preset preset = this.getPreset();
            if (preset != null) {
                this.result = Result.SET;
                this.setVisible(false);
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, "Invalid preset settings: " + e.getMessage(), e);
        }
    });
    private final Action delete = SwingUI.newAction("Delete Preset", ResourceManager.getIcon("dialog.cancel"), evt -> {
        this.result = Result.DELETE;
        this.setVisible(false);
    });
    private static final String FILE_FILTER_TOOLTIP = "<html>File Selector Expression<br><hr noshade>e.g.<br>\u2022 fn =~ /alias/<br>\u2022 ext =~ /mp4/<br>\u2022 minutes &gt; 100<br>\u2022 age &lt; 7<br>\u2022 file.isEpisode()<br>\u2022 \u2026<br></html>";

    public PresetEditor(Window owner) {
        super(owner, "Preset Editor", Dialog.ModalityType.APPLICATION_MODAL);
        JComponent c = (JComponent)this.getContentPane();
        this.presetNameHeader = new HeaderPanel();
        this.inheritRadio = new JRadioButton("<html>Use <b>Original Files</b> selection</html>");
        this.selectRadio = new JRadioButton("<html>Do <b>Select</b> files</html>");
        this.pathInput = new JTextField(40);
        this.filterEditor = this.createEditor();
        this.formatEditor = this.createEditor();
        this.actionCombo = this.createRenameActionCombo();
        this.providerCombo = this.createDataProviderCombo();
        this.sortOrderCombo = new JComboBox<SortOrder>(SortOrder.values());
        this.matchModeCombo = new JComboBox<String>(Preset.getSupportedMatchModes());
        this.languageCombo = this.createLanguageCombo();
        this.inputPanel = new JPanel(new MigLayout("insets 0, fill"));
        this.inputPanel.setOpaque(false);
        this.inputPanel.add((Component)new JLabel("Input Folder:"), "gap indent");
        this.inputPanel.add((Component)this.pathInput, "growx, gap rel");
        this.inputPanel.add((Component)SwingUI.createImageButton(this.selectInputFolder), "gap 0px, wrap");
        this.inputPanel.add((Component)new JLabel("Includes:"), "gap indent, skip 1, split 3");
        this.inputPanel.add((Component)this.wrapEditor(this.filterEditor), "growx, gap rel");
        this.inputPanel.add((Component)SwingUI.createImageButton(this.listFiles), "gap rel");
        JPanel inputGroup = this.createGroupPanel("Files");
        inputGroup.add(this.selectRadio);
        inputGroup.add((Component)this.inheritRadio, "wrap");
        inputGroup.add(this.inputPanel);
        JPanel formatGroup = this.createGroupPanel("Format");
        formatGroup.add(new JLabel("Expression:"));
        formatGroup.add((Component)this.wrapEditor(this.formatEditor), "growx, gap rel");
        formatGroup.add((Component)SwingUI.createImageButton(this.editFormatExpression), "gap 10px");
        JPanel searchGroup = this.createGroupPanel("Options");
        searchGroup.add((Component)new JLabel("Datasource:"), "sg label");
        searchGroup.add(this.providerCombo, "sg combo");
        searchGroup.add((Component)new JLabel("Episode Order:"), "sg label, gap indent");
        searchGroup.add(this.sortOrderCombo, "sg combo, wrap");
        searchGroup.add((Component)new JLabel("Language:"), "sg label");
        searchGroup.add(this.languageCombo, "sg combo");
        searchGroup.add((Component)new JLabel("Match Mode:"), "sg label, gap indent");
        searchGroup.add(this.matchModeCombo, "sg combo, wrap");
        searchGroup.add((Component)new JLabel("Rename Action:"), "sg label");
        searchGroup.add(this.actionCombo, "sg combo, wrap");
        c.setLayout(new MigLayout("insets dialog, hidemode 3, nogrid, fill"));
        c.add((Component)this.presetNameHeader, "wmin 150px, hmin 75px, growx, dock north");
        c.add((Component)inputGroup, "growx, wrap");
        c.add((Component)formatGroup, "growx, wrap");
        c.add((Component)searchGroup, "growx, wrap push");
        c.add((Component)new JButton(this.ok), "tag apply");
        c.add((Component)new JButton(this.delete), "tag cancel");
        ButtonGroup inputButtonGroup = new ButtonGroup();
        inputButtonGroup.add(this.inheritRadio);
        inputButtonGroup.add(this.selectRadio);
        this.inheritRadio.setSelected(true);
        this.selectRadio.addItemListener(evt -> this.updateComponentStates());
        this.providerCombo.addItemListener(evt -> this.updateComponentStates());
        this.updateComponentStates();
        this.setSize(730, 570);
        this.filterEditor.setToolTipText(FILE_FILTER_TOOLTIP);
    }

    public void updateComponentStates() {
        Datasource ds = (Datasource)this.providerCombo.getSelectedItem();
        boolean input = this.selectRadio.isSelected();
        this.inputPanel.setVisible(input);
        this.sortOrderCombo.setEnabled(ds instanceof EpisodeListProvider);
        this.languageCombo.setEnabled(ds instanceof EpisodeListProvider || ds instanceof MovieIdentificationService);
        this.matchModeCombo.setEnabled(ds instanceof EpisodeListProvider || ds instanceof MovieIdentificationService);
    }

    public void setPreset(Preset p) {
        this.presetNameHeader.getTitleLabel().setText(p.getName());
        this.pathInput.setText(p.getInputFolder() == null ? "" : p.getInputFolder().getPath());
        this.filterEditor.setText(p.getIncludeFilter() == null ? "" : p.getIncludeFilter().getExpressionFilter().getExpression());
        this.formatEditor.setText(p.getFormat() == null ? "" : p.getFormat().getExpression());
        this.providerCombo.setSelectedItem(p.getDatasource() == null ? WebServices.TheTVDB : p.getDatasource());
        this.sortOrderCombo.setSelectedItem((Object)(p.getSortOrder() == null ? SortOrder.Airdate : p.getSortOrder()));
        this.matchModeCombo.setSelectedItem(p.getMatchMode() == null ? "Opportunistic" : p.getMatchMode());
        this.actionCombo.setSelectedItem(p.getRenameAction() == null ? StandardRenameAction.MOVE : p.getRenameAction());
        if (p.getLanguage() != null && !p.getLanguage().getCode().equals(((Language)this.languageCombo.getSelectedItem()).getCode())) {
            for (int i = 0; i < this.languageCombo.getModel().getSize(); ++i) {
                if (!p.getLanguage().getCode().equals(((Language)this.languageCombo.getModel().getElementAt(i)).getCode())) continue;
                this.languageCombo.setSelectedIndex(i);
                break;
            }
        }
        this.selectRadio.setSelected(p.getInputFolder() != null);
        this.updateComponentStates();
    }

    public Preset getPreset() throws Exception {
        String name = this.presetNameHeader.getTitleLabel().getText();
        File path = this.inheritRadio.isSelected() ? null : new File(this.pathInput.getText());
        ExpressionFilter includes = this.inheritRadio.isSelected() ? null : new ExpressionFilter(this.filterEditor.getText());
        ExpressionFileFormat format = this.formatEditor.getText().trim().isEmpty() ? null : new ExpressionFileFormat(this.formatEditor.getText());
        Datasource database = (Datasource)this.providerCombo.getSelectedItem();
        SortOrder sortOrder = this.sortOrderCombo.isEnabled() ? (SortOrder)((Object)this.sortOrderCombo.getSelectedItem()) : null;
        String matchMode = this.matchModeCombo.isEnabled() ? (String)this.matchModeCombo.getSelectedItem() : null;
        Language language = this.languageCombo.isEnabled() ? (Language)this.languageCombo.getSelectedItem() : null;
        StandardRenameAction action = this.actionCombo.isEnabled() ? (StandardRenameAction)this.actionCombo.getSelectedItem() : null;
        return new Preset(name, path, includes, format, database, sortOrder, matchMode, language, action);
    }

    private JPanel createGroupPanel(String title) {
        JPanel inputGroup = new JPanel(new MigLayout("insets dialog, hidemode 3, nogrid, fill"));
        inputGroup.setBorder(BorderFactory.createTitledBorder(title));
        return inputGroup;
    }

    private RSyntaxTextArea createEditor() {
        RSyntaxTextArea editor = new RSyntaxTextArea(new RSyntaxDocument("text/groovy"), "", 1, 80);
        editor.setAntiAliasingEnabled(true);
        editor.setAnimateBracketMatching(false);
        editor.setAutoIndentEnabled(false);
        editor.setClearWhitespaceLinesEnabled(false);
        editor.setBracketMatchingEnabled(true);
        editor.setCloseCurlyBraces(false);
        editor.setCodeFoldingEnabled(false);
        editor.setHyperlinksEnabled(false);
        editor.setUseFocusableTips(false);
        editor.setHighlightCurrentLine(false);
        editor.setLineWrap(false);
        editor.setPaintMarkOccurrencesBorder(false);
        editor.setPaintTabLines(false);
        editor.setMarkOccurrences(false);
        editor.setFont(new Font("Monospaced", 0, 14));
        return editor;
    }

    private RTextScrollPane wrapEditor(RSyntaxTextArea editor) {
        RTextScrollPane scroll = new RTextScrollPane(editor, false);
        scroll.setLineNumbersEnabled(false);
        scroll.setFoldIndicatorEnabled(false);
        scroll.setIconRowHeaderEnabled(false);
        scroll.setVerticalScrollBarPolicy(21);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setBackground(editor.getBackground());
        scroll.setOpaque(true);
        scroll.setBorder(this.pathInput.getBorder());
        return scroll;
    }

    private JComboBox<Datasource> createDataProviderCombo() {
        JComboBox<Datasource> combo = new JComboBox<Datasource>(Preset.getSupportedServices());
        ListCellRenderer<Datasource> renderer = combo.getRenderer();
        combo.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (Datasource)value, index, isSelected, cellHasFocus);
            if (value instanceof Datasource) {
                Datasource provider = value;
                label.setText(provider.getName());
                label.setIcon(provider.getIcon());
            }
            return label;
        });
        return combo;
    }

    private JComboBox<Language> createLanguageCombo() {
        JComboBox<Language> combo = new JComboBox<Language>(Preset.getSupportedLanguages());
        ListCellRenderer<Language> renderer = combo.getRenderer();
        combo.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (Language)value, index, isSelected, cellHasFocus);
            if (value instanceof Language) {
                Language it = value;
                label.setText(it.getName());
                label.setIcon(ResourceManager.getFlagIcon(it.getCode()));
            }
            return label;
        });
        return combo;
    }

    private JComboBox<RenameAction> createRenameActionCombo() {
        JComboBox<RenameAction> combo = new JComboBox<RenameAction>(Preset.getSupportedActions());
        ListCellRenderer<StandardRenameAction> renderer = combo.getRenderer();
        combo.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (StandardRenameAction)value, index, isSelected, cellHasFocus);
            if (value instanceof StandardRenameAction) {
                StandardRenameAction it = (StandardRenameAction)value;
                label.setText(it.getDisplayName());
                label.setIcon(ResourceManager.getIcon("rename.action." + it.toString().toLowerCase()));
            }
            return label;
        });
        return combo;
    }

    public Result getResult() {
        return this.result;
    }

    static enum Result {
        SET,
        DELETE,
        CANCEL;

    }
}

