/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.filebot.ResourceManager;
import net.filebot.similarity.EpisodeMetrics;
import net.filebot.similarity.Match;
import net.filebot.similarity.MetricCascade;
import net.filebot.similarity.MetricMin;
import net.filebot.ui.rename.RenameModel;
import net.filebot.ui.rename.TextColorizer;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.DefaultFancyListCellRenderer;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Episode;
import net.miginfocom.swing.MigLayout;

class RenameListCellRenderer
extends DefaultFancyListCellRenderer {
    private RenameModel renameModel;
    private String home;
    private TypeRenderer typeRenderer = new TypeRenderer();
    private Color noMatchGradientBeginColor = new Color(0xB7B7B7);
    private Color noMatchGradientEndColor = new Color(0x9A9A9A);
    private Color warningGradientBeginColor = Color.RED;
    private Color warningGradientEndColor = new Color(14423100);
    private TextColorizer textColorizer = new TextColorizer();

    public RenameListCellRenderer(RenameModel renameModel, File home) {
        super(new Insets(4, 7, 4, 7));
        this.renameModel = renameModel;
        this.home = home.getPath();
        this.setHighlightingEnabled(false);
        this.setLayout(new MigLayout("insets 0, fill", "align left", "align center"));
        this.add((Component)this.typeRenderer, "gap rel:push, hidemode 3");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = 28;
        return dim;
    }

    @Override
    public void configureListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.configureListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setOpaque(false);
        this.setIcon(null);
        this.typeRenderer.setVisible(false);
        this.typeRenderer.setAlpha(1.0f);
        if (!this.renameModel.hasComplement(index)) {
            if (isSelected) {
                this.setGradientColors(this.noMatchGradientBeginColor, this.noMatchGradientEndColor);
            } else {
                this.setForeground(this.noMatchGradientBeginColor);
                this.typeRenderer.setAlpha(0.5f);
            }
        }
        if (this.renameModel.preserveExtension() && index < this.renameModel.size() && this.renameModel.getMatch(index).getCandidate() != null) {
            this.typeRenderer.setText(this.getType((File)this.renameModel.getMatch(index).getCandidate()));
            this.typeRenderer.setVisible(true);
        }
        if (value instanceof File) {
            File file = (File)value;
            if (this.renameModel.preserveExtension()) {
                this.setText(FileUtilities.getName(file));
            } else {
                this.setText(isSelected || !this.renameModel.hasComplement(index) ? this.formatPath(file) : this.colorizePath(file, true));
            }
        } else if (value instanceof RenameModel.FormattedFuture) {
            float matchProbablity;
            RenameModel.FormattedFuture formattedFuture = (RenameModel.FormattedFuture)value;
            float f = matchProbablity = this.renameModel.hasComplement(index) ? this.getMatchProbablity(formattedFuture.getMatch()) : 1.0f;
            if (formattedFuture.isDone() && !formattedFuture.isCancelled()) {
                if (!this.renameModel.preserveExtension() && this.renameModel.hasComplement(index)) {
                    File file = (File)this.renameModel.getMatch(index).getCandidate();
                    File path = this.resolveAbsolutePath(file.getParentFile(), formattedFuture.toString(), null);
                    this.setText(isSelected || matchProbablity < 1.0f ? this.formatPath(path) : this.colorizePath(path, true));
                    String ext = FileUtilities.getExtension(path);
                    this.typeRenderer.setText(ext != null ? ext.toLowerCase() : "MISSING EXTENSION");
                    if (file.isDirectory()) {
                        this.typeRenderer.setText("Folder");
                    }
                    this.typeRenderer.setVisible(true);
                } else {
                    File path = new File(formattedFuture.toString());
                    this.setText(isSelected || matchProbablity < 1.0f || !this.renameModel.hasComplement(index) ? this.formatPath(path) : this.colorizePath(path, !this.renameModel.preserveExtension()));
                }
            } else {
                this.setText(formattedFuture.preview());
            }
            switch (formattedFuture.getState()) {
                case PENDING: {
                    this.setIcon(ResourceManager.getIcon("worker.pending"));
                    break;
                }
                case STARTED: {
                    this.setIcon(ResourceManager.getIcon("worker.started"));
                    break;
                }
            }
            if (this.renameModel.hasComplement(index)) {
                RenameModel.FormattedFuture pathFuture;
                this.setOpaque(true);
                this.setBackground(SwingUI.derive(this.warningGradientBeginColor, (1.0f - matchProbablity) * 0.5f));
                if (matchProbablity < 1.0f && isSelected) {
                    this.setGradientColors(this.warningGradientBeginColor, this.warningGradientEndColor);
                    this.setIcon(ResourceManager.getIcon("status.warning"));
                    if (formattedFuture.isComplexFormat()) {
                        this.typeRenderer.setVisible(true);
                        this.typeRenderer.setAlpha(1.0f);
                        this.typeRenderer.setText(formattedFuture.getMatch().getValue().toString());
                    }
                }
                if ((pathFuture = (RenameModel.FormattedFuture)value).isDone() && !pathFuture.isCancelled()) {
                    File to;
                    File from = (File)this.renameModel.getMatch(index).getCandidate();
                    if (FileUtilities.equalsCaseSensitive(from, to = this.resolveAbsolutePath(from.getParentFile(), pathFuture.toString(), this.renameModel.preserveExtension() ? FileUtilities.getExtension(from) : null))) {
                        this.setIcon(ResourceManager.getIcon("dialog.continue"));
                    } else if (to.exists() && !to.equals(from)) {
                        this.setIcon(ResourceManager.getIcon("dialog.cancel"));
                    }
                }
            }
        }
    }

    protected String formatPath(File file) {
        if (file.getPath().startsWith(this.home)) {
            return "~" + FileUtilities.normalizePathSeparators(file.getPath().substring(this.home.length()));
        }
        return FileUtilities.normalizePathSeparators(file.getPath());
    }

    protected String colorizePath(File file, boolean hasExtension) {
        StringBuilder html = new StringBuilder(256);
        this.textColorizer.colorizePath(html, new File(this.formatPath(file)), hasExtension);
        return html.toString();
    }

    protected File resolveAbsolutePath(File targetDir, String path, String extension) {
        File f = new File(extension == null || extension.isEmpty() ? path : String.format("%s.%s", path, extension));
        if (!f.isAbsolute()) {
            f = new File(targetDir, f.getPath());
        }
        return f.getAbsoluteFile();
    }

    protected float getMatchProbablity(Match<Object, File> match) {
        if (match.getValue() == null || match.getCandidate() == null) {
            return 1.0f;
        }
        if (match.getValue() instanceof Episode) {
            float f = EpisodeMetrics.verificationMetric().getSimilarity(match.getValue(), match.getCandidate());
            return (f + 1.0f) / 2.0f;
        }
        MetricCascade fsm = new MetricCascade(new MetricMin(EpisodeMetrics.FileSize, 0.0f), EpisodeMetrics.FileName, EpisodeMetrics.EpisodeIdentifier);
        float f = fsm.getSimilarity(match.getValue(), match.getCandidate());
        if (f != 0.0f) {
            return Math.max(f, 0.0f);
        }
        return 1.0f;
    }

    protected String getType(File file) {
        if (file.isDirectory()) {
            return "Folder";
        }
        String extension = FileUtilities.getExtension(file);
        if (extension != null) {
            return extension.toLowerCase();
        }
        return "File";
    }

    private static class TypeRenderer
    extends DefaultListCellRenderer {
        private final Insets margin = new Insets(0, 10, 0, 0);
        private final Insets padding = new Insets(0, 6, 0, 5);
        private final int arc = 10;
        private Color gradientBeginColor = new Color(0xFFCC00);
        private Color gradientEndColor = new Color(0xFF9900);
        private float alpha = 1.0f;

        public TypeRenderer() {
            this.setOpaque(false);
            this.setForeground(new Color(0x141414));
            this.setBorder(new CompoundBorder(new EmptyBorder(this.margin), new EmptyBorder(this.padding)));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(this.margin.left, this.margin.top, this.getWidth() - (this.margin.left + this.margin.right), this.getHeight(), 10.0f, 10.0f);
            g2d.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
            g2d.setPaint(GradientStyle.TOP_TO_BOTTOM.getGradientPaint(shape, this.gradientBeginColor, this.gradientEndColor));
            g2d.fill(shape);
            g2d.setFont(this.getFont());
            g2d.setPaint(this.getForeground());
            Rectangle2D textBounds = g2d.getFontMetrics().getStringBounds(this.getText(), g2d);
            g2d.drawString(this.getText(), (float)(shape.getCenterX() - textBounds.getX() - textBounds.getWidth() / 2.0), (float)(shape.getCenterY() - textBounds.getY() - textBounds.getHeight() / 2.0));
        }

        public void setAlpha(float alpha) {
            this.alpha = alpha;
        }
    }
}

