/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingWorker;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.ExpressionFormatter;
import net.filebot.ui.rename.MatchFormatter;
import net.filebot.ui.rename.MatchModel;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;

public class RenameModel
extends MatchModel<Object, File> {
    private final FormattedFutureEventList names = new FormattedFutureEventList(this.values());
    private final Map<Object, MatchFormatter> formatters = new LinkedHashMap<Object, MatchFormatter>();
    private final MatchFormatter defaultFormatter = new MatchFormatter(){

        @Override
        public boolean canFormat(Match<?, ?> match) {
            return true;
        }

        @Override
        public String preview(Match<?, ?> match) {
            return FileUtilities.replacePathSeparators(String.valueOf(match.getValue())).trim();
        }

        @Override
        public String format(Match<?, ?> match, boolean extension, Map<?, ?> context) {
            return this.preview(match);
        }
    };
    private boolean preserveExtension = true;

    public EventList<FormattedFuture> names() {
        return this.names;
    }

    public EventList<File> files() {
        return this.candidates();
    }

    public boolean preserveExtension() {
        return this.preserveExtension;
    }

    public void setPreserveExtension(boolean preserveExtension) {
        this.preserveExtension = preserveExtension;
        this.names.refresh();
    }

    public Map<File, File> getRenameMap() {
        LinkedHashMap<File, File> map = new LinkedHashMap<File, File>();
        for (int i = 0; i < this.names.size(); ++i) {
            String extension;
            if (!this.hasComplement(i)) continue;
            File source = new File(((File)this.files().get(i)).getPath());
            FormattedFuture task = this.names.get(i);
            StringBuilder destination = new StringBuilder();
            try {
                destination.append((String)task.get(0L, TimeUnit.SECONDS));
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(String.format("\"%s\" could not be formatted: %s.", task.preview(), e.getCause().getMessage()));
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(String.format("\"%s\" has not been formatted yet.", task.preview()));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.preserveExtension && (extension = FileUtilities.getExtension(source)) != null) {
                destination.append('.').append(extension.toLowerCase());
            }
            if (map.put(source, new File(destination.toString())) == null) continue;
            throw new IllegalStateException("Duplicate source file: " + source.getName());
        }
        return map;
    }

    public void useFormatter(Object key, MatchFormatter formatter) {
        if (formatter != null) {
            this.formatters.put(key, formatter);
        } else {
            this.formatters.remove(key);
        }
        this.names.refresh();
    }

    private MatchFormatter getFormatter(Match<Object, File> match) {
        for (MatchFormatter formatter : this.formatters.values()) {
            if (!formatter.canFormat(match)) continue;
            return formatter;
        }
        return this.defaultFormatter;
    }

    public Map<File, Object> getMatchContext(Match<Object, File> match) {
        if (match.getValue() == null || match.getCandidate() == null) {
            return Collections.emptyMap();
        }
        return new AbstractMap<File, Object>(){

            @Override
            public Set<Map.Entry<File, Object>> entrySet() {
                LinkedHashSet<Map.Entry<File, Object>> context = new LinkedHashSet<Map.Entry<File, Object>>();
                for (Match match : RenameModel.this.matches()) {
                    if (match.getValue() == null || match.getCandidate() == null) continue;
                    context.add(new AbstractMap.SimpleImmutableEntry(match.getCandidate(), match.getValue()));
                }
                return context;
            }
        };
    }

    public static class FormattedFuture
    extends SwingWorker<String, Void> {
        private final Match<Object, File> match;
        private final boolean extension;
        private final Map<File, Object> context;
        private final MatchFormatter formatter;

        private FormattedFuture(Match<Object, File> match, boolean extension, MatchFormatter formatter, Map<File, Object> context) {
            this.match = match;
            this.extension = extension;
            this.formatter = formatter;
            this.context = context;
        }

        public boolean isComplexFormat() {
            return this.formatter instanceof ExpressionFormatter;
        }

        public Match<Object, File> getMatch() {
            return this.match;
        }

        public String preview() {
            return this.formatter.preview(this.match).trim();
        }

        @Override
        protected String doInBackground() throws Exception {
            return this.formatter.format(this.match, this.extension, this.context).trim();
        }

        public String toString() {
            if (this.isDone()) {
                try {
                    return (String)this.get(0L, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    if (t.getCause() != null && t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    return String.format("[%s] %s", ExceptionUtilities.getMessage(t), this.preview());
                }
            }
            return this.preview();
        }
    }

    private class FormattedFutureEventList
    extends TransformedList<Object, FormattedFuture> {
        private final List<FormattedFuture> futures;
        private final Executor backgroundFormatter;
        private final PropertyChangeListener futureListener;

        public FormattedFutureEventList(EventList<Object> source) {
            super(source);
            this.futures = new ArrayList<FormattedFuture>();
            this.backgroundFormatter = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            this.futureListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int index = FormattedFutureEventList.this.futures.indexOf(evt.getSource());
                    if (index >= 0 && index < FormattedFutureEventList.this.size()) {
                        FormattedFuture future = (FormattedFuture)evt.getSource();
                        FormattedFutureEventList.this.updates.beginEvent(true);
                        FormattedFutureEventList.this.updates.elementUpdated(index, future, future);
                        FormattedFutureEventList.this.updates.commitEvent();
                    }
                }
            };
            this.source.addListEventListener(this);
        }

        @Override
        public FormattedFuture get(int index) {
            return this.futures.get(index);
        }

        @Override
        protected boolean isWritable() {
            return false;
        }

        @Override
        public void add(int index, FormattedFuture value) {
            this.source.add(index, value.getMatch().getValue());
        }

        @Override
        public FormattedFuture set(int index, FormattedFuture value) {
            FormattedFuture obsolete = this.get(index);
            this.source.set(index, value.getMatch().getValue());
            return obsolete;
        }

        @Override
        public FormattedFuture remove(int index) {
            FormattedFuture obsolete = this.get(index);
            this.source.remove(index);
            return obsolete;
        }

        @Override
        public void listChanged(ListEvent<Object> listChanges) {
            this.updates.beginEvent(true);
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                if (type == 2 || type == 1) {
                    Match<Object, File> match = RenameModel.this.getMatch(index);
                    final FormattedFuture future = new FormattedFuture(match, !RenameModel.this.preserveExtension, RenameModel.this.getFormatter(match), RenameModel.this.getMatchContext(match));
                    if (type == 2) {
                        this.futures.add(index, future);
                        this.updates.elementInserted(index, future);
                    } else if (type == 1) {
                        FormattedFuture obsolete = this.futures.set(index, future);
                        this.cancel(obsolete);
                        SwingUI.invokeLater(50, new Runnable(){

                            @Override
                            public void run() {
                                if (future.getState() == SwingWorker.StateValue.PENDING) {
                                    future.firePropertyChange("state", null, (Object)SwingWorker.StateValue.PENDING);
                                }
                            }
                        });
                    }
                    this.submit(future);
                    continue;
                }
                if (type != 0) continue;
                FormattedFuture obsolete = this.futures.remove(index);
                this.cancel(obsolete);
                this.updates.elementDeleted(index, obsolete);
            }
            this.updates.commitEvent();
        }

        public void refresh() {
            this.updates.beginEvent(true);
            for (int i = 0; i < this.size(); ++i) {
                FormattedFuture obsolete = this.futures.get(i);
                Match<Object, File> match = obsolete.getMatch();
                FormattedFuture future = new FormattedFuture(match, !RenameModel.this.preserveExtension, RenameModel.this.getFormatter(match), RenameModel.this.getMatchContext(match));
                this.cancel(this.futures.set(i, future));
                this.submit(future);
                this.updates.elementUpdated(i, obsolete, future);
            }
            this.updates.commitEvent();
        }

        private void submit(FormattedFuture future) {
            future.addPropertyChangeListener(this.futureListener);
            this.backgroundFormatter.execute(future);
        }

        private void cancel(FormattedFuture future) {
            future.removePropertyChangeListener(this.futureListener);
            future.cancel(true);
        }
    }
}

