/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.awt.Color;
import java.awt.Component;
import java.io.FileNotFoundException;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import net.filebot.ui.sfv.ChecksumRow;
import net.filebot.ui.sfv.ChecksumTableModel;
import net.filebot.ui.sfv.SwingWorkerCellRenderer;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.ui.SwingUI;

public class ChecksumCellRenderer
extends DefaultTableCellRenderer {
    private final SwingWorkerCellRenderer progressRenderer = new SwingWorkerCellRenderer();
    private final Color verificationForeground = new Color(39168);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isError;
        boolean pendingWorker = false;
        if (value instanceof SwingWorker) {
            if (((SwingWorker)value).getState() != SwingWorker.StateValue.PENDING) {
                return this.progressRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            pendingWorker = true;
        }
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        boolean bl = isError = table.getValueAt(row, 0) == ChecksumRow.State.ERROR;
        this.setForeground(isSelected ? table.getSelectionForeground() : (isError ? Color.RED : (this.isVerificationColumn(table, column) ? this.verificationForeground : table.getForeground())));
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setFont(this.getFont().deriveFont(isError ? 1 : 0));
        if (pendingWorker) {
            this.setText("Pending...");
        } else if (value == null && !isSelected) {
            this.setBackground(SwingUI.derive(table.getGridColor(), 0.1f));
        } else if (value instanceof FileNotFoundException) {
            this.setText("File not found");
        } else if (value instanceof Throwable) {
            this.setText(ExceptionUtilities.getRootCauseMessage((Throwable)value));
        }
        return this;
    }

    private boolean isVerificationColumn(JTable table, int column) {
        ChecksumTableModel model = (ChecksumTableModel)table.getModel();
        int modelColumn = table.getColumnModel().getColumn(column).getModelIndex();
        return model.isVerificationColumn(modelColumn);
    }
}

