/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.SwingWorker;
import net.filebot.hash.Hash;
import net.filebot.hash.HashType;

class ChecksumComputationTask
extends SwingWorker<Map<HashType, String>, Void> {
    private final File file;
    private final HashType hashType;

    public ChecksumComputationTask(File file, HashType hashType) {
        this.file = file;
        this.hashType = hashType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<HashType, String> doInBackground() throws Exception {
        Hash hash = this.hashType.newHash();
        long length = this.file.length();
        try (FileInputStream in = new FileInputStream(this.file);){
            byte[] buffer = new byte[65536];
            long position = 0L;
            int len = 0;
            while ((len = ((InputStream)in).read(buffer)) >= 0) {
                hash.update(buffer, 0, len);
                this.setProgress((int)((position += (long)len) * 100L / length));
                if (!this.isCancelled() && !Thread.interrupted()) continue;
                throw new CancellationException();
            }
        }
        return Collections.singletonMap(this.hashType, hash.digest());
    }
}

