/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.SwingPropertyChangeSupport;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationUtilities;
import net.filebot.ui.sfv.ChecksumCell;

class ChecksumRow {
    private String name;
    private Map<File, ChecksumCell> hashes = new HashMap<File, ChecksumCell>(4);
    private State state = State.UNKNOWN;
    private String embeddedChecksum;
    private final PropertyChangeListener updateStateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName())) {
                ChecksumRow.this.setState(ChecksumRow.this.getState(ChecksumRow.this.hashes.values()));
            }
        }
    };
    private SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);

    public ChecksumRow(String name) {
        this.name = name;
        this.embeddedChecksum = VerificationUtilities.getEmbeddedChecksum(name);
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State newValue) {
        State oldValue = this.state;
        this.state = newValue;
        this.pcs.firePropertyChange("state", (Object)oldValue, (Object)newValue);
    }

    public ChecksumCell getChecksum(File root) {
        return this.hashes.get(root);
    }

    public Collection<ChecksumCell> values() {
        return Collections.unmodifiableCollection(this.hashes.values());
    }

    public ChecksumCell put(ChecksumCell cell) {
        ChecksumCell old = this.hashes.put(cell.getRoot(), cell);
        this.state = this.getState(this.hashes.values());
        cell.addPropertyChangeListener(this.updateStateListener);
        return old;
    }

    public void dispose() {
        for (PropertyChangeListener listener : this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(listener);
        }
        for (ChecksumCell cell : this.hashes.values()) {
            cell.dispose();
        }
        this.name = null;
        this.embeddedChecksum = null;
        this.hashes = null;
        this.state = null;
        this.pcs = null;
    }

    protected State getState(Collection<ChecksumCell> cells) {
        for (ChecksumCell cell : cells) {
            if (cell.getState() == ChecksumCell.State.ERROR) {
                return State.ERROR;
            }
            if (cell.getState() == ChecksumCell.State.READY) continue;
            return State.UNKNOWN;
        }
        HashSet<String> checksumSet = new HashSet<String>(2);
        EnumSet<State> verdictSet = EnumSet.noneOf(State.class);
        for (HashType type : HashType.values()) {
            checksumSet.clear();
            for (ChecksumCell cell : cells) {
                String checksum = cell.getChecksum(type);
                if (checksum == null) continue;
                checksumSet.add(checksum.toLowerCase());
            }
            verdictSet.add(this.getVerdict(checksumSet));
        }
        return Collections.max(verdictSet);
    }

    protected State getVerdict(Set<String> checksumSet) {
        String checksum;
        if (checksumSet.size() < 1) {
            return State.UNKNOWN;
        }
        if (checksumSet.size() > 1) {
            return State.ERROR;
        }
        if (this.embeddedChecksum != null && (checksum = checksumSet.iterator().next()).length() == this.embeddedChecksum.length() && !checksum.equalsIgnoreCase(this.embeddedChecksum)) {
            return State.WARNING;
        }
        return State.OK;
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.state, this.name, this.hashes});
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static enum State {
        UNKNOWN,
        OK,
        WARNING,
        ERROR;

    }
}

