/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.UserFiles;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.subtitle.SubtitleAutoMatchDialog;
import net.filebot.ui.subtitle.upload.SubtitleUploadDialog;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Datasource;
import net.filebot.web.OpenSubtitlesClient;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.VideoHashSubtitleService;

abstract class SubtitleDropTarget
extends JButton {
    private final DropTargetAdapter dropHandler = new DropTargetAdapter(){

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            DropAction dropAction = DropAction.Accept;
            try {
                dropAction = SubtitleDropTarget.this.getDropAction(FileTransferable.getFilesFromTransferable(dtde.getTransferable()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            SubtitleDropTarget.this.setDropAction(dropAction);
            if (dropAction != DropAction.Cancel) {
                dtde.acceptDrag(0x40000000);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            SubtitleDropTarget.this.setDropAction(DropAction.Accept);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            boolean accept = false;
            try {
                List<File> files = FileTransferable.getFilesFromTransferable(dtde.getTransferable());
                boolean bl = accept = SubtitleDropTarget.this.getDropAction(files) != DropAction.Cancel;
                if (accept) {
                    SwingUtilities.invokeLater(() -> SubtitleDropTarget.this.handleDrop(files));
                }
            }
            catch (Exception e) {
                Logging.log.log(Level.WARNING, e.getMessage(), e);
            }
            dtde.dropComplete(accept);
            this.dragExit(dtde);
        }
    };
    private final ActionListener clickHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            List<File> files = UserFiles.showLoadDialogSelectFiles(true, true, null, FileUtilities.ExtensionFileFilter.union(MediaTypes.VIDEO_FILES, MediaTypes.SUBTITLE_FILES), "Select Video Folder", evt);
            if (files.size() > 0 && SubtitleDropTarget.this.getDropAction(files) != DropAction.Cancel) {
                SubtitleDropTarget.this.handleDrop(files);
            }
        }
    };

    public SubtitleDropTarget() {
        this.setHorizontalAlignment(0);
        this.setHideActionText(true);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.setDropAction(DropAction.Accept);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addActionListener(this.clickHandler);
        new DropTarget(this, this.dropHandler);
    }

    protected void setDropAction(DropAction dropAction) {
        this.setIcon(this.getIcon(dropAction));
    }

    protected abstract OpenSubtitlesClient getSubtitleService();

    protected abstract boolean handleDrop(List<File> var1);

    protected abstract DropAction getDropAction(List<File> var1);

    protected abstract Icon getIcon(DropAction var1);

    public static abstract class Upload
    extends SubtitleDropTarget {
        @Override
        protected DropAction getDropAction(List<File> selection) {
            return FileUtilities.filter(selection, MediaTypes.SUBTITLE_FILES).size() > 0 || FileUtilities.filter(selection, FileUtilities.FOLDERS).size() > 0 ? DropAction.Accept : DropAction.Cancel;
        }

        @Override
        protected boolean handleDrop(List<File> selection) {
            if (this.getSubtitleService().isAnonymous()) {
                Logging.log.info(String.format("%s: You must be logged in to upload subtitles.", this.getSubtitleService().getName()));
                return false;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (Settings.isMacSandbox()) {
                MacAppUtilities.askUnlockFolders(SwingUI.getWindow(this), selection);
            }
            List<File> files = FileUtilities.listFiles(selection, FileUtilities.FILES, FileUtilities.HUMAN_NAME_ORDER);
            List<File> videos = FileUtilities.filter(files, MediaTypes.VIDEO_FILES);
            List<File> subtitles = FileUtilities.filter(files, MediaTypes.SUBTITLE_FILES);
            LinkedHashMap<File, File> uploadPlan = new LinkedHashMap<File, File>();
            for (File subtitle : subtitles) {
                File video = this.getVideoForSubtitle(subtitle, FileUtilities.filter(videos, new FileUtilities.ParentFilter(subtitle.getParentFile())));
                uploadPlan.put(subtitle, video);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (uploadPlan.size() > 0) {
                this.handleUpload(uploadPlan);
                return true;
            }
            return false;
        }

        protected void handleUpload(Map<File, File> uploadPlan) {
            SubtitleUploadDialog dialog = new SubtitleUploadDialog(this.getSubtitleService(), SwingUI.getWindow(this));
            dialog.setIconImage(SwingUI.getImage(this.getIcon(DropAction.Accept)));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(950, 575);
            dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
            dialog.setUploadPlan(uploadPlan);
            dialog.startChecking();
            dialog.setVisible(true);
        }

        protected File getVideoForSubtitle(File subtitle, List<File> videos) {
            return this.findMatch(subtitle, videos, FileUtilities::getName).orElseGet(() -> this.findMatch(subtitle, FileUtilities.getChildren(subtitle.getParentFile(), MediaTypes.VIDEO_FILES), FileUtilities::getName).orElse(null));
        }

        private Optional<File> findMatch(File file, List<File> options, Function<File, String> comparator) {
            String subtitleFileName = comparator.apply(file).toLowerCase();
            for (File it : options) {
                if (subtitleFileName.length() <= 0 || !subtitleFileName.startsWith(comparator.apply(it).toLowerCase())) continue;
                return Optional.of(it);
            }
            return Optional.empty();
        }

        @Override
        protected Icon getIcon(DropAction dropAction) {
            if (dropAction == DropAction.Accept) {
                return ResourceManager.getIcon("subtitle.exact.upload");
            }
            return ResourceManager.getIcon("message.error");
        }
    }

    public static abstract class Download
    extends SubtitleDropTarget {
        public abstract VideoHashSubtitleService[] getVideoHashSubtitleServices();

        public abstract SubtitleProvider[] getSubtitleProviders();

        public abstract Locale getQueryLanguage();

        @Override
        protected DropAction getDropAction(List<File> selection) {
            return FileUtilities.filter(selection, MediaTypes.VIDEO_FILES, FileUtilities.FOLDERS).size() > 0 ? DropAction.Accept : DropAction.Cancel;
        }

        @Override
        protected boolean handleDrop(List<File> selection) {
            if (this.getQueryLanguage() == null) {
                Logging.log.info("Please select your preferred subtitle language.");
                return false;
            }
            if (this.getSubtitleService().isAnonymous() && !Settings.isAppStore()) {
                Logging.log.info(String.format("%s: Please enter your login details.", this.getSubtitleService().getName()));
                return false;
            }
            List<File> files = FileUtilities.listFiles(selection, (FileFilter)MediaTypes.VIDEO_FILES, FileUtilities.HUMAN_NAME_ORDER);
            if (files.size() > 0) {
                this.handleDownload(files);
                return true;
            }
            return false;
        }

        protected boolean handleDownload(Collection<File> videoFiles) {
            SubtitleAutoMatchDialog dialog = new SubtitleAutoMatchDialog(SwingUI.getWindow(this));
            dialog.setVideoFiles(videoFiles.toArray(new File[0]));
            for (VideoHashSubtitleService videoHashSubtitleService : this.getVideoHashSubtitleServices()) {
                dialog.addSubtitleService(videoHashSubtitleService);
            }
            for (Datasource datasource : this.getSubtitleProviders()) {
                dialog.addSubtitleService((SubtitleProvider)datasource);
            }
            dialog.startQuery(this.getQueryLanguage());
            dialog.setIconImage(SwingUI.getImage(this.getIcon(DropAction.Accept)));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(1050, 600);
            dialog.setLocationRelativeTo(dialog.getOwner());
            dialog.setVisible(true);
            return true;
        }

        @Override
        protected Icon getIcon(DropAction dropAction) {
            switch (dropAction) {
                case Accept: {
                    return ResourceManager.getIcon("subtitle.exact.download");
                }
            }
            return ResourceManager.getIcon("message.error");
        }
    }

    public static enum DropAction {
        Accept,
        Cancel;

    }
}

