/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.awt.Component;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.filebot.subtitle.SubtitleFormat;
import net.miginfocom.swing.MigLayout;

public class SubtitleFileChooser
extends JFileChooser {
    protected final JComboBox format = new JComboBox();
    protected final JComboBox encoding = new JComboBox();
    protected final JSpinner offset = new JSpinner(new SpinnerNumberModel(0, -14400000, 14400000, 100));

    public SubtitleFileChooser() {
        this.setAccessory(this.createAcessory());
        this.setDefaultOptions();
    }

    protected void setDefaultOptions() {
        this.setFormatOptions(Collections.singleton(SubtitleFormat.SubRip));
        LinkedHashSet<Charset> encodings = new LinkedHashSet<Charset>(2);
        encodings.add(StandardCharsets.UTF_8);
        encodings.add(Charset.defaultCharset());
        this.setEncodingOptions(encodings);
    }

    protected JComponent createAcessory() {
        JPanel acessory = new JPanel(new MigLayout("nogrid"));
        acessory.add((Component)new JLabel("Encoding:"), "wrap rel");
        acessory.add((Component)this.encoding, "sg w, wrap para");
        acessory.add((Component)new JLabel("Format:"), "wrap rel");
        acessory.add((Component)this.format, "sg w, wrap para");
        acessory.add((Component)new JLabel("Timing Offset:"), "wrap rel");
        acessory.add((Component)this.offset, "wmax 50px");
        acessory.add(new JLabel("ms"));
        return acessory;
    }

    public void setEncodingOptions(Set<Charset> options) {
        this.encoding.setModel(new DefaultComboBoxModel<Object>(options.toArray()));
    }

    public Charset getSelectedEncoding() {
        return (Charset)this.encoding.getSelectedItem();
    }

    public void setFormatOptions(Set<SubtitleFormat> options) {
        this.format.setModel(new DefaultComboBoxModel<Object>(options.toArray()));
    }

    public SubtitleFormat getSelectedFormat() {
        return (SubtitleFormat)((Object)this.format.getSelectedItem());
    }

    public long getTimingOffset() {
        return ((Integer)this.offset.getValue()).intValue();
    }
}

