/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.event.SwingPropertyChangeSupport;
import net.filebot.Language;
import net.filebot.MediaTypes;
import net.filebot.util.FileUtilities;
import net.filebot.vfs.ArchiveType;
import net.filebot.vfs.MemoryFile;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.SubtitleProvider;

public class SubtitlePackage {
    private final SubtitleProvider provider;
    private final SubtitleDescriptor subtitle;
    private final Language language;
    private Download download;
    private final PropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);

    public SubtitlePackage(SubtitleProvider provider, SubtitleDescriptor subtitle) {
        this.provider = provider;
        this.subtitle = subtitle;
        this.language = Language.findLanguage(subtitle.getLanguageName());
        this.download = new Download(subtitle);
        this.download.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("phase")) {
                    SubtitlePackage.this.pcs.firePropertyChange("download.phase", evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    public SubtitleProvider getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.subtitle.getName();
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getType() {
        return this.subtitle.getType();
    }

    public Download getDownload() {
        return this.download;
    }

    public void reset() {
        this.download.cancel(false);
        Download old = this.download;
        this.download = new Download(this.subtitle);
        for (PropertyChangeListener listener : old.getPropertyChangeSupport().getPropertyChangeListeners()) {
            old.removePropertyChangeListener(listener);
            this.download.addPropertyChangeListener(listener);
        }
        this.pcs.firePropertyChange("download.phase", (Object)old.getPhase(), (Object)this.download.getPhase());
    }

    public String toString() {
        return this.subtitle.getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static class Download
    extends SwingWorker<List<MemoryFile>, Void> {
        private final SubtitleDescriptor subtitle;
        private Phase current = Phase.PENDING;

        private Download(SubtitleDescriptor descriptor) {
            this.subtitle = descriptor;
        }

        public void start() {
            this.setPhase(Phase.WAITING);
            this.execute();
        }

        @Override
        protected List<MemoryFile> doInBackground() throws Exception {
            this.setPhase(Phase.DOWNLOADING);
            ByteBuffer data = this.subtitle.fetch();
            if (this.isCancelled()) {
                return null;
            }
            this.setPhase(Phase.EXTRACTING);
            ArchiveType archiveType = ArchiveType.forName(this.subtitle.getType());
            if (archiveType == ArchiveType.UNKOWN) {
                return Collections.singletonList(new MemoryFile(this.subtitle.getPath(), data));
            }
            List<MemoryFile> vfs = this.extract(archiveType, data);
            if (vfs.isEmpty() && archiveType != ArchiveType.ZIP) {
                vfs = this.extract(ArchiveType.ZIP, data);
            }
            if (vfs.isEmpty()) {
                throw new IOException("Cannot extract files from archive");
            }
            return vfs;
        }

        private List<MemoryFile> extract(ArchiveType archiveType, ByteBuffer data) throws IOException {
            ArrayList<MemoryFile> vfs = new ArrayList<MemoryFile>();
            for (MemoryFile file : archiveType.fromData(data)) {
                if (MediaTypes.SUBTITLE_FILES.accept(file.getName())) {
                    vfs.add(file);
                    continue;
                }
                ArchiveType type = ArchiveType.forName(FileUtilities.getExtension(file.getName()));
                if (type == ArchiveType.UNKOWN) continue;
                vfs.addAll(this.extract(type, file.getData()));
            }
            return vfs;
        }

        @Override
        protected void done() {
            this.setPhase(Phase.DONE);
        }

        private void setPhase(Phase phase) {
            Phase old = this.current;
            this.current = phase;
            this.firePropertyChange("phase", (Object)old, (Object)phase);
        }

        public boolean isStarted() {
            return this.current != Phase.PENDING;
        }

        public Phase getPhase() {
            return this.current;
        }

        static enum Phase {
            PENDING,
            WAITING,
            DOWNLOADING,
            EXTRACTING,
            DONE;

        }
    }
}

