/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.geom.Path2D;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.media.MediaDetection;
import net.filebot.ui.AbstractSearchPanel;
import net.filebot.ui.LanguageComboBox;
import net.filebot.ui.LanguageComboBoxModel;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.subtitle.SubtitleDownloadComponent;
import net.filebot.ui.subtitle.SubtitleDropTarget;
import net.filebot.ui.subtitle.SubtitlePackage;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.LabelProvider;
import net.filebot.util.ui.LinkButton;
import net.filebot.util.ui.SimpleLabelProvider;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.OpenSubtitlesClient;
import net.filebot.web.SearchResult;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.SubtitleSearchResult;
import net.filebot.web.VideoHashSubtitleService;
import net.miginfocom.swing.MigLayout;

public class SubtitlePanel
extends AbstractSearchPanel<SubtitleProvider, SubtitlePackage> {
    private LanguageComboBox languageComboBox = new LanguageComboBox(LanguageComboBoxModel.ALL_LANGUAGES, this.getSettings());
    private final SubtitleDropTarget uploadDropTarget = new SubtitleDropTarget.Upload(){

        @Override
        public OpenSubtitlesClient getSubtitleService() {
            return WebServices.OpenSubtitles;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(0.0, 0.0);
            ((Path2D)path).lineTo(0.0, this.getHeight() - 1 - 12);
            ((Path2D)path).lineTo(12.0, this.getHeight() - 1);
            ((Path2D)path).lineTo(this.getWidth() - 1 - 12, this.getHeight() - 1);
            ((Path2D)path).lineTo(this.getWidth() - 1, this.getHeight() - 1 - 12);
            ((Path2D)path).lineTo(this.getWidth() - 1, 0.0);
            g2d.setPaint(this.getBackground());
            g2d.fill(path);
            g2d.setPaint(Color.gray);
            g2d.draw(path);
            g2d.translate(2, 0);
            super.paintComponent(g2d);
            g2d.dispose();
        }
    };
    private final SubtitleDropTarget downloadDropTarget = new SubtitleDropTarget.Download(){

        @Override
        public Locale getLocale() {
            return SubtitlePanel.this.languageComboBox.getModel().getSelectedItem() == LanguageComboBoxModel.ALL_LANGUAGES ? Locale.ROOT : SubtitlePanel.this.languageComboBox.getModel().getSelectedItem().getLocale();
        }

        @Override
        public VideoHashSubtitleService[] getVideoHashSubtitleServices() {
            return WebServices.getVideoHashSubtitleServices(this.getLocale());
        }

        @Override
        public SubtitleProvider[] getSubtitleProviders() {
            return WebServices.getSubtitleProviders(this.getLocale());
        }

        @Override
        public OpenSubtitlesClient getSubtitleService() {
            return WebServices.OpenSubtitles;
        }

        @Override
        public Locale getQueryLanguage() {
            return SubtitlePanel.this.languageComboBox.getModel().getSelectedItem() == LanguageComboBoxModel.ALL_LANGUAGES ? null : SubtitlePanel.this.languageComboBox.getModel().getSelectedItem().getLocale();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(0.0, 0.0);
            ((Path2D)path).lineTo(0.0, this.getHeight() - 1 - 12);
            ((Path2D)path).lineTo(12.0, this.getHeight() - 1);
            ((Path2D)path).lineTo(this.getWidth() - 1 - 12, this.getHeight() - 1);
            ((Path2D)path).lineTo(this.getWidth() - 1, this.getHeight() - 1 - 12);
            ((Path2D)path).lineTo(this.getWidth() - 1, 0.0);
            g2d.setPaint(this.getBackground());
            g2d.fill(path);
            g2d.setPaint(Color.gray);
            g2d.draw(path);
            g2d.translate(2, 0);
            super.paintComponent(g2d);
            g2d.dispose();
        }
    };
    private final QueryFilter<Integer> seasonFilter = new QueryFilter<Integer>("season", s -> s == null ? -1 : Integer.parseInt(s));
    private final QueryFilter<Integer> episodeFilter = new QueryFilter<Integer>("episode", s -> s == null ? -1 : Integer.parseInt(s));
    protected final Action setUserAction = new AbstractAction("Login", ResourceManager.getIcon("action.user")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            final JDialog authPanel = new JDialog(SwingUI.getWindow(SubtitlePanel.this), Dialog.ModalityType.APPLICATION_MODAL);
            authPanel.setTitle("Login");
            authPanel.setLocation(SwingUI.getOffsetLocation(authPanel.getOwner()));
            JPanel osdbGroup = new JPanel(new MigLayout("fill, insets panel"));
            osdbGroup.setBorder(new TitledBorder("OpenSubtitles"));
            osdbGroup.add((Component)new JLabel("Username:"), "gap rel");
            final JTextField osdbUser = new JTextField(12);
            osdbGroup.add((Component)osdbUser, "growx, wrap rel");
            osdbGroup.add((Component)new JLabel("Password:"), "gap rel");
            final JPasswordField osdbPass = new JPasswordField(12);
            osdbGroup.add((Component)osdbPass, "growx, wrap unrel");
            String[] osdbAuth = WebServices.getLogin("osdb.user");
            osdbUser.setText(osdbAuth[0]);
            if (osdbUser.getText().isEmpty()) {
                osdbGroup.add((Component)new LinkButton("Register Account", "Register to increase your download quota", WebServices.OpenSubtitles.getIcon(), URI.create("http://www.opensubtitles.org/en/newuser")), "spanx 2, tag left");
            } else {
                osdbGroup.add((Component)new LinkButton("Upgrade Account", "Upgrade to increase your download quota", WebServices.OpenSubtitles.getIcon(), URI.create("http://www.opensubtitles.org/en/support")), "spanx 2, tag left");
            }
            JRootPane container = authPanel.getRootPane();
            container.setLayout(new MigLayout("fill, insets dialog"));
            container.removeAll();
            container.add((Component)osdbGroup, "growx, wrap");
            AbstractAction ok = new AbstractAction("OK", ResourceManager.getIcon("dialog.continue")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    authPanel.setCursor(Cursor.getPredefinedCursor(3));
                    boolean approved = true;
                    try {
                        if (osdbUser.getText().length() > 0 && osdbPass.getPassword().length > 0) {
                            OpenSubtitlesClient osdb = new OpenSubtitlesClient(Settings.getApplicationName(), Settings.getApplicationVersion());
                            osdb.setUser(osdbUser.getText(), FileUtilities.md5(new String(osdbPass.getPassword())));
                            osdb.login();
                            WebServices.requestThreadPool.submit(() -> {
                                try {
                                    Map limits = (Map)osdb.getServerInfo().get("download_limits");
                                    Logging.log.log(Level.INFO, String.format("Your daily download quota is at %s of %s.", limits.get("client_24h_download_count"), limits.get("client_24h_download_limit")));
                                    osdb.logout();
                                }
                                catch (Exception e) {
                                    Logging.debug.warning(e.getMessage());
                                }
                            });
                        } else if (osdbUser.getText().isEmpty()) {
                            WebServices.setLogin("osdb.user", null, null);
                        }
                    }
                    catch (Exception e) {
                        Logging.log.log(Level.WARNING, "OpenSubtitles: " + e.getMessage());
                        approved = false;
                    }
                    authPanel.setCursor(Cursor.getPredefinedCursor(0));
                    if (approved) {
                        WebServices.setLogin("osdb.user", osdbUser.getText(), new String(osdbPass.getPassword()));
                        authPanel.setVisible(false);
                    }
                }
            };
            AbstractAction cancel = new AbstractAction("Cancel", ResourceManager.getIcon("dialog.cancel")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    authPanel.setVisible(false);
                }
            };
            container.add((Component)new JButton(cancel), "tag cancel, split 2");
            container.add((Component)new JButton(ok), "tag ok");
            authPanel.pack();
            authPanel.setVisible(true);
        }
    };

    public SubtitlePanel() {
        this.historyPanel.setColumnHeader(0, "Search");
        this.historyPanel.setColumnHeader(1, "Number of Subtitles");
        this.add(this.languageComboBox, "gap indent, sgy button", 1);
        this.add(SwingUI.createImageButton(this.setUserAction), "w pref!, h 2+pref!, gap rel, sgy button", 2);
        this.add(this.uploadDropTarget, "width 1.45cm!, height 1.2cm!, pos n 0% 100%-1.8cm n", 0);
        this.add(this.downloadDropTarget, "width 1.45cm!, height 1.2cm!, pos n 0% 100%-0.15cm n", 0);
    }

    @Subscribe
    public void handle(Transferable transferable) throws Exception {
        SubtitleDropTarget target = this.downloadDropTarget;
        List<File> files = FileTransferable.getFilesFromTransferable(transferable);
        if (files != null && files.size() > 0 && target.getDropAction(files) != SubtitleDropTarget.DropAction.Cancel) {
            target.handleDrop(files);
        }
    }

    @Override
    protected Collection<String> getHistory(SubtitleProvider engine) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        for (SubtitleSearchResult it : MediaDetection.releaseInfo.getOpenSubtitlesIndex()) {
            names.add(it.toString());
        }
        return names;
    }

    protected SubtitleProvider[] getSearchEngines() {
        return WebServices.getSubtitleProviders(this.getLocale());
    }

    @Override
    protected LabelProvider<SubtitleProvider> getSearchEngineLabelProvider() {
        return SimpleLabelProvider.forClass(SubtitleProvider.class);
    }

    @Override
    protected Settings getSettings() {
        return Settings.forPackage(SubtitlePanel.class);
    }

    protected SubtitleRequestProcessor createRequestProcessor() {
        SubtitleProvider provider = (SubtitleProvider)this.searchTextField.getSelectButton().getSelectedValue();
        if (provider instanceof OpenSubtitlesClient && ((OpenSubtitlesClient)provider).isAnonymous() && !Settings.isAppStore()) {
            Logging.log.info(String.format("%s: Please enter your login details first.", ((OpenSubtitlesClient)provider).getName()));
            SwingUtilities.invokeLater(() -> this.setUserAction.actionPerformed(new ActionEvent(this.searchTextField, 0, "login")));
            return null;
        }
        String query = this.searchTextField.getText();
        int season = this.seasonFilter.match(query);
        query = this.seasonFilter.remove(query).trim();
        int episode = this.episodeFilter.match(query);
        query = this.episodeFilter.remove(query).trim();
        Language language = this.languageComboBox.getModel().getSelectedItem();
        return new SubtitleRequestProcessor(new SubtitleRequest(provider, query, season, episode, language));
    }

    protected static class SubtitleRequestProcessor
    extends AbstractSearchPanel.RequestProcessor<SubtitleRequest, SubtitlePackage> {
        public SubtitleRequestProcessor(SubtitleRequest request) {
            super(request, new SubtitleDownloadComponent());
        }

        @Override
        public Collection<SubtitleSearchResult> search() throws Exception {
            return ((SubtitleRequest)this.request).getProvider().search(((SubtitleRequest)this.request).getSearchText());
        }

        @Override
        public SubtitleSearchResult getSearchResult() {
            return (SubtitleSearchResult)super.getSearchResult();
        }

        @Override
        public Collection<SubtitlePackage> fetch() throws Exception {
            ArrayList<SubtitlePackage> packages = new ArrayList<SubtitlePackage>();
            for (SubtitleDescriptor subtitle : ((SubtitleRequest)this.request).getProvider().getSubtitleList(this.getSearchResult(), ((SubtitleRequest)this.request).getEpisodeFilter(), ((SubtitleRequest)this.request).getLanguage())) {
                packages.add(new SubtitlePackage(((SubtitleRequest)this.request).getProvider(), subtitle));
            }
            return packages;
        }

        @Override
        public URI getLink() {
            return ((SubtitleRequest)this.request).getProvider().getSubtitleListLink(this.getSearchResult(), ((SubtitleRequest)this.request).getLanguage());
        }

        @Override
        public void process(Collection<SubtitlePackage> subtitles) {
            this.getComponent().setLanguageVisible(((SubtitleRequest)this.request).getLanguage() == null);
            this.getComponent().getPackageModel().addAll(subtitles);
        }

        @Override
        public SubtitleDownloadComponent getComponent() {
            return (SubtitleDownloadComponent)super.getComponent();
        }

        @Override
        public String getStatusMessage(Collection<SubtitlePackage> result) {
            return result.isEmpty() ? "No subtitles found" : String.format("%d subtitles", result.size());
        }

        @Override
        public Icon getIcon() {
            return ((SubtitleRequest)this.request).provider.getIcon();
        }

        @Override
        protected void configureSelectDialog(SelectDialog<SearchResult> selectDialog) {
            super.configureSelectDialog(selectDialog);
            selectDialog.getMessageLabel().setText("Select a Show / Movie:");
        }
    }

    protected static class SubtitleRequest
    extends AbstractSearchPanel.Request {
        private final SubtitleProvider provider;
        private final Language language;
        private final int season;
        private final int episode;

        public SubtitleRequest(SubtitleProvider provider, String searchText, int season, int episode, Language language) {
            super(searchText);
            this.season = season;
            this.episode = episode;
            this.provider = provider;
            this.language = language;
        }

        public SubtitleProvider getProvider() {
            return this.provider;
        }

        public Locale getLanguage() {
            return this.language == LanguageComboBoxModel.ALL_LANGUAGES ? null : this.language.getLocale();
        }

        public int[][] getEpisodeFilter() {
            Object object;
            if (this.season >= 0 && this.episode >= 0) {
                int[][] nArrayArray = new int[1][];
                object = nArrayArray;
                nArrayArray[0] = new int[]{this.season, this.episode};
            } else if (this.season >= 0) {
                int[][] nArrayArray = new int[1][];
                object = nArrayArray;
                nArrayArray[0] = new int[]{this.season, -1};
            } else {
                object = null;
            }
            return object;
        }
    }

    protected static class QueryFilter<T> {
        private final Pattern pattern;
        private final Function<String, T> parser;

        public QueryFilter(String key, Function<String, T> parser) {
            this.pattern = Pattern.compile("(?:" + key + "):(\\w+)", 258);
            this.parser = parser;
        }

        public T match(String s) {
            Matcher m = this.pattern.matcher(s);
            if (m.find()) {
                return this.parser.apply(m.group(m.groupCount()));
            }
            return this.parser.apply(null);
        }

        public String remove(String s) {
            return this.pattern.matcher(s).replaceAll("");
        }
    }
}

