/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle.upload;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import net.filebot.Logging;
import net.filebot.media.MediaDetection;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.subtitle.upload.Status;
import net.filebot.ui.subtitle.upload.SubtitleMapping;
import net.filebot.ui.subtitle.upload.SubtitleMappingTableModel;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Movie;
import net.filebot.web.OpenSubtitlesClient;
import net.filebot.web.SubtitleSearchResult;

class MovieEditor
implements TableCellEditor {
    private OpenSubtitlesClient database;

    public MovieEditor(OpenSubtitlesClient database) {
        this.database = database;
    }

    private String guessQuery(SubtitleMapping mapping) {
        String fn = FileUtilities.getName(mapping.getVideo() != null ? mapping.getVideo() : mapping.getSubtitle());
        String sn = MediaDetection.getSeriesNameMatcher(true).matchByEpisodeIdentifier(fn);
        if (sn != null) {
            return MediaDetection.stripReleaseInfo(sn, true);
        }
        return MediaDetection.stripReleaseInfo(fn, false);
    }

    private String getFileHint(SubtitleMapping mapping) {
        File f = mapping.getVideo() != null ? mapping.getVideo() : mapping.getSubtitle();
        try {
            return MediaDetection.getStructurePathTail(f).getPath();
        }
        catch (Exception e) {
            return f.getPath();
        }
    }

    private List<SubtitleSearchResult> runSearch(SubtitleMapping mapping, JTable table) throws Exception {
        String input = SwingUI.showInputDialog("Enter movie / series name:", this.guessQuery(mapping), this.getFileHint(mapping), table);
        if (input != null && input.length() > 0) {
            return this.database.searchIMDB(input);
        }
        return null;
    }

    private void runSelect(List<SubtitleSearchResult> options, SubtitleMapping mapping, JTable table) {
        if (options == null) {
            return;
        }
        if (options.isEmpty()) {
            Logging.log.warning(String.format("%s: No results", this.database.getName()));
            return;
        }
        SelectDialog<SubtitleSearchResult> dialog = new SelectDialog<SubtitleSearchResult>(table, options);
        dialog.pack();
        dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
        dialog.setVisible(true);
        Movie selectedValue = dialog.getSelectedValue();
        if (selectedValue != null) {
            mapping.setIdentity(selectedValue);
            if (mapping.getIdentity() != null && mapping.getLanguage() != null && mapping.getVideo() != null) {
                mapping.setState(Status.CheckPending);
            }
        }
    }

    private void reset(Exception error, JTable table) {
        SwingUI.getWindow(table).setCursor(Cursor.getPredefinedCursor(0));
        if (error != null) {
            Logging.debug.warning(error.getMessage());
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        SwingUI.getWindow(table).setCursor(Cursor.getPredefinedCursor(3));
        SubtitleMappingTableModel model = (SubtitleMappingTableModel)table.getModel();
        SubtitleMapping mapping = model.getData()[table.convertRowIndexToModel(row)];
        SwingUI.newSwingWorker(() -> this.runSearch(mapping, table), options -> {
            this.runSelect((List<SubtitleSearchResult>)options, mapping, table);
            this.reset(null, table);
        }, error -> this.reset((Exception)error, table)).execute();
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject evt) {
        return false;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener evt) {
    }
}

