/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Array;

public class ArrayTransferable<T>
implements Transferable {
    private final T[] array;

    public static DataFlavor flavor(Class<?> componentType) {
        return new DataFlavor(Array.newInstance(componentType, 0).getClass(), "Array");
    }

    public ArrayTransferable(T[] array) {
        this.array = array;
    }

    public T[] getArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.getArray();
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{new DataFlavor(this.array.getClass(), "Array")};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.array.getClass().equals(flavor.getRepresentationClass());
    }
}

