/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.filebot.ui.transfer.ClipboardHandler;
import net.filebot.util.StringUtilities;

public class DefaultClipboardHandler
implements ClipboardHandler {
    @Override
    public void exportToClipboard(JComponent component, Clipboard clip, int action) throws IllegalStateException {
        clip.setContents(new StringSelection(this.export(component)), null);
    }

    protected String export(JComponent component) {
        if (component instanceof JList) {
            return this.export((JList)component);
        }
        if (component instanceof JTree) {
            return this.export((JTree)component);
        }
        if (component instanceof JTable) {
            return this.export((JTable)component);
        }
        throw new IllegalArgumentException("JComponent not supported: " + component);
    }

    protected String export(Stream<?> values) {
        return StringUtilities.join(values, (CharSequence)System.lineSeparator());
    }

    protected String export(JList list) {
        return this.export(list.getSelectedValuesList().stream());
    }

    protected String export(JTree tree) {
        return this.export(Arrays.stream(tree.getSelectionPaths()).map(TreePath::getLastPathComponent));
    }

    protected String export(JTable table) {
        return this.export(Arrays.stream(table.getSelectedRows()).map(row -> table.getRowSorter().convertRowIndexToModel(row)).mapToObj(row -> IntStream.range(0, table.getColumnCount()).mapToObj(column -> table.getModel().getValueAt(row, column)).map(v -> Objects.toString(v, "")).collect(Collectors.joining("\t"))));
    }
}

