/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FileUtilities;

public abstract class FileTransferablePolicy
extends TransferablePolicy {
    @Override
    public boolean accept(Transferable tr) throws Exception {
        try {
            List<File> files = FileTransferable.getFilesFromTransferable(tr);
            if (files != null && files.size() > 0 && FileUtilities.containsOnly(files, FileUtilities.TEMPORARY)) {
                return false;
            }
            return this.accept(files);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return false;
        }
    }

    @Override
    public void handleTransferable(Transferable tr, TransferablePolicy.TransferAction action) throws Exception {
        List<File> files = FileTransferable.getFilesFromTransferable(tr);
        if (action == TransferablePolicy.TransferAction.PUT) {
            this.clear();
        }
        this.load(files, action);
    }

    protected abstract boolean accept(List<File> var1);

    protected abstract void load(List<File> var1, TransferablePolicy.TransferAction var2) throws IOException;

    protected abstract void clear();

    public abstract String getFileFilterDescription();

    public abstract List<String> getFileFilterExtensions();
}

