/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.UserFiles;
import net.filebot.ui.transfer.FileExportHandler;
import net.filebot.util.FileUtilities;

public class SaveAction
extends AbstractAction {
    public static final String EXPORT_HANDLER = "exportHandler";

    public SaveAction(FileExportHandler exportHandler) {
        this("Save as ...", ResourceManager.getIcon("action.save"), exportHandler);
    }

    public SaveAction(String name, Icon icon, FileExportHandler exportHandler) {
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.putValue(EXPORT_HANDLER, exportHandler);
    }

    public FileExportHandler getExportHandler() {
        return (FileExportHandler)this.getValue(EXPORT_HANDLER);
    }

    protected boolean canExport() {
        return this.getExportHandler().canExport();
    }

    protected void export(File file) throws IOException {
        this.getExportHandler().export(file);
    }

    protected File getDefaultFile() {
        return new File(FileUtilities.validateFileName(this.getExportHandler().getDefaultFileName()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            File file;
            if (this.canExport() && (file = UserFiles.showSaveDialogSelectFile(false, this.getDefaultFile(), (String)this.getValue("Name"), evt)) != null) {
                this.export(file);
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

