/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.filebot.ui.transfer.ByteBufferTransferable;
import net.filebot.ui.transfer.FileTransferable;

public class TextFileTransferable
extends ByteBufferTransferable {
    private final String text;

    public TextFileTransferable(String name, String text) {
        this(name, text, StandardCharsets.UTF_8);
    }

    public TextFileTransferable(final String name, final String text, final Charset charset) {
        super((Map<String, ByteBuffer>)new AbstractMap<String, ByteBuffer>(){

            @Override
            public Set<Map.Entry<String, ByteBuffer>> entrySet() {
                return Collections.singletonMap(name, charset.encode(text)).entrySet();
            }
        });
        this.text = text;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (super.isDataFlavorSupported(flavor)) {
            return super.getTransferData(flavor);
        }
        if (flavor.isFlavorTextType()) {
            return this.text;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, FileTransferable.uriListFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return super.isDataFlavorSupported(flavor) || flavor.isFlavorTextType();
    }
}

