/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public enum BOM {
    UTF_8(-17, -69, -65),
    UTF_16BE(-2, -1),
    UTF_16LE(-1, -2),
    UTF_32BE(0, 0, -2, -1),
    UTF_32LE(-1, -2, 0, 0),
    GB_18030(-124, 49, -107, 51);

    public static final int SIZE = 4;
    private byte[] bom;

    private BOM(byte ... bom) {
        this.bom = bom;
    }

    public int size() {
        return this.bom.length;
    }

    public boolean matches(byte[] bytes) {
        if (bytes.length < this.bom.length) {
            return false;
        }
        for (int i = 0; i < this.bom.length; ++i) {
            if (this.bom[i] == bytes[i]) continue;
            return false;
        }
        return true;
    }

    public Charset getCharset() {
        switch (this) {
            case UTF_8: {
                return StandardCharsets.UTF_8;
            }
            case UTF_16BE: {
                return StandardCharsets.UTF_16BE;
            }
            case UTF_16LE: {
                return StandardCharsets.UTF_16LE;
            }
            case UTF_32BE: {
                return Charset.forName("UTF-32BE");
            }
            case UTF_32LE: {
                return Charset.forName("UTF-32LE");
            }
            case GB_18030: {
                return Charset.forName("GB18030");
            }
        }
        return null;
    }

    public static BOM detect(byte[] bytes) {
        for (BOM bom : BOM.values()) {
            if (!bom.matches(bytes)) continue;
            return bom;
        }
        return null;
    }
}

