/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingWorker;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.web.WebRequest;

public class DownloadTask
extends SwingWorker<ByteBuffer, Void> {
    public static final String DOWNLOAD_STATE = "download state";
    public static final String DOWNLOAD_PROGRESS = "download progress";
    private URL url;
    private long contentLength = -1L;
    private DownloadState state = DownloadState.PENDING;
    private Map<String, String> postParameters;
    private Map<String, String> requestHeaders;
    private Map<String, List<String>> responseHeaders;

    public DownloadTask(URL url) {
        this.url = url;
    }

    protected HttpURLConnection createConnection() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        if (this.requestHeaders != null) {
            for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer doInBackground() throws Exception {
        this.setDownloadState(DownloadState.CONNECTING);
        HttpURLConnection connection = this.createConnection();
        if (this.postParameters != null) {
            ByteBuffer postData = StandardCharsets.UTF_8.encode(WebRequest.encodeParameters(this.postParameters, true));
            connection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.addRequestProperty("Content-Length", String.valueOf(postData.remaining()));
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            WritableByteChannel out = Channels.newChannel(connection.getOutputStream());
            out.write(postData);
            out.close();
        }
        this.contentLength = connection.getContentLength();
        this.responseHeaders = connection.getHeaderFields();
        this.setDownloadState(DownloadState.DOWNLOADING);
        ReadableByteChannel in = Channels.newChannel(connection.getInputStream());
        ByteBufferOutputStream buffer = new ByteBufferOutputStream((int)(this.contentLength > 0L ? this.contentLength : 65536L));
        try {
            while (!this.isCancelled() && buffer.transferFrom(in) >= 0) {
                this.firePropertyChange(DOWNLOAD_PROGRESS, null, buffer.position());
                if (!this.isContentLengthKnown()) continue;
                this.setProgress((int)((long)(buffer.position() * 100) / this.contentLength));
            }
        }
        catch (IOException e) {
            if (this.isContentLengthKnown()) {
                throw e;
            }
        }
        finally {
            in.close();
            this.setDownloadState(DownloadState.DONE);
        }
        return buffer.getByteBuffer();
    }

    protected void setDownloadState(DownloadState state) {
        this.state = state;
        this.firePropertyChange(DOWNLOAD_STATE, null, (Object)state);
    }

    public DownloadState getDownloadState() {
        return this.state;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isContentLengthKnown() {
        return this.contentLength >= 0L;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = new HashMap<String, String>(requestHeaders);
    }

    public void setPostParameters(Map<String, String> postParameters) {
        this.postParameters = new HashMap<String, String>(postParameters);
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, String> getPostParameters() {
        return this.postParameters;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public static enum DownloadState {
        PENDING,
        CONNECTING,
        DOWNLOADING,
        DONE;

    }
}

