/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.util.FileUtilities;

public class FileSet
extends AbstractSet<Path> {
    private static final int ROOT_LEVEL = -1;
    private final Map<Path, FileSet> folders = new HashMap<Path, FileSet>(4, 2.0f);
    private final Set<Path> files = new HashSet<Path>(4, 2.0f);

    private boolean add(Path e, int depth) {
        if (e.getNameCount() - 1 == depth) {
            return this.files.add(e.getFileName());
        }
        return this.folders.computeIfAbsent(depth == -1 ? e.getRoot() : e.getName(depth), k -> new FileSet()).add(e, depth + 1);
    }

    @Override
    public boolean add(Path e) {
        return this.add(e, -1);
    }

    @Override
    public boolean add(File e) {
        return this.add(e.toPath());
    }

    @Override
    public boolean add(String e) {
        return this.add(Paths.get(e, new String[0]));
    }

    private boolean contains(Path e, int depth) {
        FileSet subSet;
        if (e.getNameCount() - 1 == depth) {
            return this.files.contains(e.getFileName());
        }
        if (e.getNameCount() - 1 > depth && (subSet = this.folders.get(depth == -1 ? e.getRoot() : e.getName(depth))) != null) {
            return subSet.contains(e, depth + 1);
        }
        return false;
    }

    public boolean contains(Path e) {
        return this.contains(e, -1);
    }

    @Override
    public boolean contains(Object e) {
        return this.contains(this.getPath(e));
    }

    protected Path getPath(Object path) {
        if (path instanceof Path) {
            return (Path)path;
        }
        if (path instanceof File) {
            return ((File)path).toPath();
        }
        if (path instanceof String) {
            return Paths.get((String)path, new String[0]);
        }
        if (path instanceof URI) {
            return Paths.get((URI)path);
        }
        return Paths.get(path.toString(), new String[0]);
    }

    public Map<Path, List<Path>> getRoots() {
        if (this.folders.size() != 1 || this.files.size() > 0) {
            return Collections.emptyMap();
        }
        Map.Entry<Path, FileSet> entry = this.folders.entrySet().iterator().next();
        Path parent = entry.getKey();
        Map<Path, List<Path>> next = entry.getValue().getRoots();
        if (next.size() > 0) {
            return next.entrySet().stream().collect(Collectors.toMap(it -> parent.resolve((Path)it.getKey()), it -> (List)it.getValue()));
        }
        return this.folders.entrySet().stream().collect(Collectors.toMap(it -> (Path)it.getKey(), it -> ((FileSet)it.getValue()).stream().collect(Collectors.toList())));
    }

    @Override
    public int size() {
        return this.folders.values().stream().mapToInt(f -> f.size()).sum() + this.files.size();
    }

    @Override
    public Stream<Path> stream() {
        Stream descendants = this.folders.entrySet().stream().flatMap(node -> ((FileSet)node.getValue()).stream().map(f -> ((Path)node.getKey()).resolve((Path)f)));
        Stream children = this.files.stream();
        return Stream.concat(descendants, children);
    }

    @Override
    public Spliterator<Path> spliterator() {
        return this.stream().spliterator();
    }

    @Override
    public Iterator<Path> iterator() {
        return this.stream().iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.folders.values().forEach(FileSet::clear);
        this.folders.clear();
        this.files.clear();
    }

    public void load(File f) throws IOException {
        for (String path : FileUtilities.readLines(f)) {
            try {
                this.add(path);
            }
            catch (InvalidPathException e) {
                Logging.debug.warning(e::toString);
            }
        }
    }

    public void append(File f, Collection<?> ... paths) throws IOException {
        Files.write(f.toPath(), (Iterable<? extends CharSequence>)Stream.of(paths).flatMap(Collection::stream).map(this::getPath).filter(it -> !this.contains((Path)it)).map(Path::toString).collect(Collectors.toList()), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
    }
}

