/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.Iterator;

public abstract class FilterIterator<S, T>
implements Iterator<T> {
    private final Iterator<S> sourceIterator;
    private T current = null;

    public FilterIterator(Iterable<S> source) {
        this(source.iterator());
    }

    public FilterIterator(Iterator<S> sourceIterator) {
        this.sourceIterator = sourceIterator;
    }

    @Override
    public boolean hasNext() {
        return this.peekNext(false) != null;
    }

    @Override
    public T next() {
        try {
            T t = this.peekNext(true);
            return t;
        }
        finally {
            this.current = null;
        }
    }

    private T peekNext(boolean forceNext) {
        while (this.current == null && (forceNext || this.sourceIterator.hasNext())) {
            this.current = this.filter(this.sourceIterator.next());
        }
        return this.current;
    }

    protected abstract T filter(S var1);

    @Override
    public void remove() {
        this.sourceIterator.remove();
    }
}

