/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.util.StringUtilities;

public class JsonUtilities {
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static Object readJson(CharSequence json) {
        if (json.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        return JsonReader.jsonToJava(json.toString(), Collections.singletonMap("USE_MAPS", true));
    }

    public static String json(Object object, boolean pretty) {
        return JsonWriter.objectToJson(object, Collections.singletonMap("PRETTY_PRINT", pretty));
    }

    public static Map<?, ?> asMap(Object node) {
        if (node instanceof Map) {
            return (Map)node;
        }
        return Collections.EMPTY_MAP;
    }

    public static Object[] asArray(Object node) {
        JsonObject jsonObject;
        if (node instanceof JsonObject && (jsonObject = (JsonObject)node).isArray()) {
            return jsonObject.getArray();
        }
        if (node instanceof Object[]) {
            return (Object[])node;
        }
        return EMPTY_ARRAY;
    }

    public static Map<?, ?>[] asMapArray(Object node) {
        return (Map[])Arrays.stream(JsonUtilities.asArray(node)).map(JsonUtilities::asMap).filter(m -> m.size() > 0).toArray(Map[]::new);
    }

    public static Stream<Map<?, ?>> streamJsonObjects(Object node) {
        return Arrays.stream(JsonUtilities.asMapArray(node));
    }

    public static Object[] getArray(Object node, String key) {
        return JsonUtilities.asArray(JsonUtilities.asMap(node).get(key));
    }

    public static Map<?, ?> getMap(Object node, String key) {
        return JsonUtilities.asMap(JsonUtilities.asMap(node).get(key));
    }

    public static Map<?, ?>[] getMapArray(Object node, String key) {
        return JsonUtilities.asMapArray(JsonUtilities.asMap(node).get(key));
    }

    public static Stream<Map<?, ?>> streamJsonObjects(Object node, String key) {
        return Arrays.stream(JsonUtilities.getMapArray(node, key));
    }

    public static Map<?, ?> getFirstMap(Object node, String key) {
        Object[] values = JsonUtilities.getArray(node, key);
        if (values.length > 0) {
            return JsonUtilities.asMap(values[0]);
        }
        return Collections.EMPTY_MAP;
    }

    public static String getString(Object node, String key) {
        return StringUtilities.asNonEmptyString(JsonUtilities.asMap(node).get(key));
    }

    public static Integer getInteger(Object node, String key) {
        return JsonUtilities.getStringValue(node, key, Integer::parseInt);
    }

    public static Double getDecimal(Object node, String key) {
        return JsonUtilities.getStringValue(node, key, Double::parseDouble);
    }

    public static <V> V getStringValue(Object node, String key, Function<String, V> converter) {
        String value = JsonUtilities.getString(node, key);
        if (value != null) {
            try {
                return converter.apply(JsonUtilities.getString(node, key));
            }
            catch (Exception e) {
                Logging.debug.warning(Logging.format("Bad %s value: %s => %s", key, value, e));
            }
        }
        return null;
    }

    public static <K extends Enum<K>> EnumMap<K, String> getEnumMap(Object node, Class<K> cls) {
        return JsonUtilities.getEnumMap(node, cls, StringUtilities::asNonEmptyString);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> getEnumMap(Object node, Class<K> cls, Function<Object, V> converter) {
        Map<?, ?> values = JsonUtilities.asMap(node);
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(cls);
        for (Enum key : (Enum[])cls.getEnumConstants()) {
            V value;
            Object object = values.get(key.name());
            if (object == null || (value = converter.apply(object)) == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private JsonUtilities() {
        throw new UnsupportedOperationException();
    }
}

