/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.RandomAccess;
import java.util.prefs.Preferences;
import net.filebot.util.PreferencesMap;

public class PreferencesList<T>
extends AbstractList<T>
implements RandomAccess {
    private final PreferencesMap<T> prefs;

    public PreferencesList(PreferencesMap<T> preferencesMap) {
        this.prefs = preferencesMap;
    }

    @Override
    public T get(int index) {
        return this.prefs.get(this.key(index));
    }

    private String key(int index) {
        return Integer.toString(index);
    }

    @Override
    public int size() {
        return this.prefs.size();
    }

    @Override
    public boolean add(T e) {
        this.setImpl(this.size(), e);
        return true;
    }

    @Override
    public void add(int index, T element) {
        int size = this.size();
        if (index > size) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, size));
        }
        this.copy(index, index + 1, size - index);
        this.setImpl(index, element);
    }

    private T setImpl(int index, T element) {
        return this.prefs.put(this.key(index), element);
    }

    @Override
    public T remove(int index) {
        int lastIndex = this.size() - 1;
        this.copy(index + 1, index, lastIndex - index);
        this.prefs.remove(this.key(lastIndex));
        return null;
    }

    @Override
    public T set(int index, T element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.setImpl(index, element);
    }

    private void copy(int startIndex, int newStartIndex, int count) {
        if (count == 0 || startIndex == newStartIndex) {
            return;
        }
        ArrayList copy = new ArrayList(this.subList(startIndex, startIndex + count));
        int i = newStartIndex;
        for (int n = 0; n < count; ++n) {
            this.setImpl(i, copy.get(n));
            ++i;
        }
    }

    public void trimToSize(int limit) {
        for (int i = this.size() - 1; i >= limit; --i) {
            this.remove(i);
        }
    }

    public void set(Collection<T> data) {
        this.trimToSize(data.size());
        int i = 0;
        for (T element : data) {
            this.setImpl(i++, element);
        }
    }

    @Override
    public void clear() {
        this.prefs.clear();
    }

    public static PreferencesList<String> map(Preferences prefs) {
        return new PreferencesList<String>(PreferencesMap.map(prefs));
    }

    public static <T> PreferencesList<T> map(Preferences prefs, PreferencesMap.Adapter<T> adapter) {
        return new PreferencesList<T>(PreferencesMap.map(prefs, adapter));
    }
}

