/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.prefs;

import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import net.filebot.util.prefs.PropertyFileBackingStore;

public class FilePreferences
extends AbstractPreferences {
    protected PropertyFileBackingStore store;

    public FilePreferences(PropertyFileBackingStore store) {
        super(null, "");
        this.store = store;
    }

    protected FilePreferences(FilePreferences parent, String name) {
        super(parent, name);
        this.store = parent.store;
    }

    protected String getNodeKey() {
        return this.absolutePath().substring(1);
    }

    @Override
    protected void putSpi(String key, String value) {
        this.store.setValue(this.getNodeKey(), key, value);
    }

    @Override
    protected String getSpi(String key) {
        return this.store.getValue(this.getNodeKey(), key);
    }

    @Override
    protected void removeSpi(String key) {
        this.store.removeValue(this.getNodeKey(), key);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.store.removeNode(this.getNodeKey());
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.store.getKeys(this.getNodeKey());
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.store.getChildren(this.getNodeKey());
    }

    @Override
    protected FilePreferences childSpi(String name) {
        return new FilePreferences(this, name);
    }

    @Override
    public void sync() throws BackingStoreException {
        this.syncSpi();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        try {
            this.store.sync();
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        this.flushSpi();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            this.store.flush();
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }
}

