/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.filebot.util.ui.GradientStyle;

public abstract class AbstractFancyListCellRenderer
extends JPanel
implements ListCellRenderer {
    private Color gradientBeginColor;
    private Color gradientEndColor;
    private Color highlightColor;
    private boolean borderPainted = false;
    private boolean gradientPainted = false;
    private GradientStyle gradientStyle = GradientStyle.TOP_TO_BOTTOM;
    private boolean highlightingEnabled = true;
    private final Insets margin;
    private static final Insets DEFAULT_PADDING = new Insets(7, 7, 7, 7);
    private static final Insets DEFAULT_MARGIN = new Insets(1, 1, 0, 1);

    public AbstractFancyListCellRenderer() {
        this(DEFAULT_PADDING, DEFAULT_MARGIN, null);
    }

    public AbstractFancyListCellRenderer(Insets padding) {
        this(padding, DEFAULT_MARGIN, null);
    }

    public AbstractFancyListCellRenderer(Insets padding, Insets margin) {
        this(padding, margin, null);
    }

    public AbstractFancyListCellRenderer(Insets padding, Insets margin, Color borderColor) {
        this.setLayout(new FlowLayout(0, 0, 0));
        AbstractBorder border = null;
        if (padding != null) {
            border = new EmptyBorder(padding);
        }
        if (borderColor != null) {
            border = new CompoundBorder(new LineBorder(borderColor, 1), border);
        }
        if (margin != null) {
            this.margin = margin;
            border = new CompoundBorder(new EmptyBorder(margin), border);
        } else {
            this.margin = new Insets(0, 0, 0, 0);
        }
        this.setBorder(border);
        this.setOpaque(false);
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.borderPainted) {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle2D.Double shape = new Rectangle2D.Double(this.margin.left, this.margin.top, this.getWidth() - (this.margin.left + this.margin.right), this.getHeight() - (this.margin.top + this.margin.bottom));
        if (this.isOpaque()) {
            g2d.setPaint(this.getBackground());
            g2d.fill(shape);
        }
        if (this.highlightingEnabled && this.highlightColor != null) {
            g2d.setPaint(this.highlightColor);
            g2d.fill(shape);
        }
        if (this.gradientPainted) {
            g2d.setPaint(this.gradientStyle.getGradientPaint(shape, this.gradientBeginColor, this.gradientEndColor));
            g2d.fill(shape);
        }
        super.paintComponent(g);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.configureListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.validate();
        return this;
    }

    protected void configureListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setGradientPainted(isSelected);
        this.setBorderPainted(isSelected);
        Color sc = list.getSelectionBackground();
        if (isSelected) {
            this.setGradientColors(sc.brighter(), sc);
        }
        if (this.highlightingEnabled && index % 2 == 0) {
            this.setHighlightColor(new Color(sc.getRed(), sc.getGreen(), sc.getBlue(), 28));
        } else {
            this.setHighlightColor(null);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
    }

    public void setGradientColors(Color gradientBeginColor, Color gradientEndColor) {
        this.gradientBeginColor = gradientBeginColor;
        this.gradientEndColor = gradientEndColor;
    }

    public Color getGradientBeginColor() {
        return this.gradientBeginColor;
    }

    public Color getGradientEndColor() {
        return this.gradientEndColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setGradientStyle(GradientStyle gradientStyle) {
        this.gradientStyle = gradientStyle;
    }

    public void setHighlightingEnabled(boolean highlightingEnabled) {
        this.highlightingEnabled = highlightingEnabled;
    }

    public void setBorderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
    }

    public void setGradientPainted(boolean gradientPainted) {
        this.gradientPainted = gradientPainted;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public GradientStyle getGradientStyle() {
        return this.gradientStyle;
    }

    public boolean isHighlightingEnabled() {
        return this.highlightingEnabled;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

