/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import net.filebot.Logging;

public class LinkButton
extends JButton {
    private Color color = this.getForeground();
    private Color rolloverColor = new Color(0x3399FF);
    protected final MouseListener rolloverListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            LinkButton.this.setForeground(LinkButton.this.rolloverColor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LinkButton.this.setForeground(LinkButton.this.color);
        }
    };

    public LinkButton(String text, String tooltip, Icon icon, URI uri) {
        this(new OpenUriAction(text, tooltip, icon, uri));
    }

    public LinkButton(Action action) {
        this.setAction(action);
        this.setFocusPainted(false);
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorder(null);
        this.setHorizontalAlignment(2);
        this.setIconTextGap(6);
        this.setRolloverEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void setRolloverEnabled(boolean enabled) {
        super.setRolloverEnabled(enabled);
        this.removeMouseListener(this.rolloverListener);
        if (enabled) {
            this.addMouseListener(this.rolloverListener);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setForeground(color);
    }

    public Color getRolloverColor() {
        return this.rolloverColor;
    }

    public void setRolloverColor(Color rolloverColor) {
        this.rolloverColor = rolloverColor;
    }

    protected static class OpenUriAction
    extends AbstractAction {
        public static final String URI = "uri";

        public OpenUriAction(String text, String tooltip, Icon icon, URI uri) {
            super(text, icon);
            if (uri != null) {
                this.putValue(URI, uri);
            }
            if (tooltip != null) {
                this.putValue("ShortDescription", tooltip);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                URI uri = (URI)this.getValue(URI);
                if (uri != null) {
                    Desktop.getDesktop().browse(uri);
                }
            }
            catch (Exception e) {
                Logging.debug.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

