/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.filebot.util.ui.ColorTintImageFilter;
import net.filebot.util.ui.SwingUI;

public class ListView
extends JList {
    protected final BlockSelectionHandler blockSelectionHandler = new BlockSelectionHandler();

    public ListView(ListModel dataModel) {
        super(dataModel);
        this.setSelectionMode(2);
        this.putClientProperty("List.isFileList", Boolean.TRUE);
        this.setDropMode(DropMode.ON);
        this.setLayoutOrientation(1);
        this.setVisibleRowCount(-1);
        this.setCellRenderer(new ListViewRenderer());
        this.addMouseListener(this.blockSelectionHandler);
        this.addMouseMotionListener(this.blockSelectionHandler);
    }

    public void addSelectionInterval(Rectangle selection) {
        Point p1 = selection.getLocation();
        Point p2 = new Point(p1.x + selection.width, p1.y + selection.height);
        int startIndex = this.locationToIndex(p1);
        int endIndex = this.locationToIndex(p2);
        for (int i = startIndex; i <= endIndex; ++i) {
            Rectangle cell = this.getCellBounds(i, i);
            if (cell == null || !selection.intersects(cell)) continue;
            this.addSelectionInterval(i, i);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle selection = this.blockSelectionHandler.getSelection();
        if (selection != null) {
            this.paintBlockSelection((Graphics2D)g, selection);
        }
    }

    protected void paintBlockSelection(Graphics2D g2d, Rectangle selection) {
        g2d.setPaint(SwingUI.derive(this.getSelectionBackground(), 0.3f));
        g2d.fill(selection);
        g2d.setPaint(this.getSelectionBackground());
        g2d.draw(selection);
    }

    protected String convertValueToText(Object value) {
        return value.toString();
    }

    protected Icon convertValueToIcon(Object value) {
        return null;
    }

    protected class BlockSelectionHandler
    extends MouseInputAdapter {
        private Rectangle selection;
        private Point origin;

        protected BlockSelectionHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && !ListView.this.isSelectedIndex(ListView.this.locationToIndex(e.getPoint()))) {
                this.origin = e.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.origin == null) {
                return;
            }
            if (this.selection == null) {
                this.selection = new Rectangle();
            }
            Point p2 = e.getPoint();
            p2.x = Math.max(0, Math.min(ListView.this.getWidth() - 1, p2.x));
            p2.y = Math.max(0, Math.min(ListView.this.getHeight() - 1, p2.y));
            this.selection.setFrameFromDiagonal(this.origin, p2);
            ListView.this.ensureIndexIsVisible(ListView.this.locationToIndex(p2));
            ListView.this.clearSelection();
            ListView.this.addSelectionInterval(this.selection);
            ListView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.origin = null;
            this.selection = null;
            ListView.this.repaint();
        }

        public Rectangle getSelection() {
            return this.selection;
        }
    }

    protected class ListViewRenderer
    extends DefaultListCellRenderer {
        public ListViewRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = ListView.this.convertValueToIcon(value);
            if (isSelected && icon != null) {
                icon = new ImageIcon(this.createImage(new FilteredImageSource(SwingUI.getImage(icon).getSource(), new ColorTintImageFilter(list.getSelectionBackground(), 0.5f))));
            }
            this.setText(ListView.this.convertValueToText(value));
            this.setIcon(icon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int iconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconHeight();
            int startX = iconWidth + this.getIconTextGap();
            Rectangle2D text = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g);
            g.setColor(this.getBackground());
            g.fillRect(startX - 2, 1, (int)(text.getWidth() + 6.0), this.getHeight() - 1);
            super.paintComponent(g);
        }
    }
}

