/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.filebot.Logging;
import net.filebot.Settings;

public final class SwingUI {
    public static final Color TRANSLUCENT = new Color(255, 255, 255, 0);
    private static boolean initJavaFX = true;

    public static void setNimbusLookAndFeel() {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to set Nimbus LaF", e);
        }
    }

    public static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to set System LaF", e);
        }
    }

    public static void openURI(String uri) {
        try {
            Desktop.getDesktop().browse(URI.create(uri));
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to open URI: " + uri, e);
        }
    }

    public static void copyToClipboard(String text) {
        if (text.length() > 0) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
        }
    }

    public static void checkEventDispatchThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Method must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    public static void runOnEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Color interpolateHSB(Color c1, Color c2, float f) {
        float[] hsb1 = Color.RGBtoHSB(c1.getRed(), c1.getGreen(), c1.getBlue(), null);
        float[] hsb2 = Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), null);
        float[] hsb = new float[3];
        for (int i = 0; i < hsb.length; ++i) {
            hsb[i] = hsb1[i] + (hsb2[i] - hsb1[i]) * f;
        }
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public static String escapeHTML(String s) {
        char[] sc;
        for (char c : sc = new char[]{'&', '<', '>', '\"', '\''}) {
            s = s.replace(Character.toString(c), String.format("&#%d;", c));
        }
        return s;
    }

    public static Color derive(Color color, float alpha) {
        return new Color((int)(alpha * 255.0f) << 24 | color.getRGB() & 0xFFFFFF, true);
    }

    public static String toHex(Color c) {
        return c == null ? "inherit" : String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    public static boolean isShiftOrAltDown(InputEvent evt) {
        return SwingUI.checkModifiers(evt.getModifiers(), 1) || SwingUI.checkModifiers(evt.getModifiers(), 8);
    }

    public static boolean isShiftOrAltDown(ActionEvent evt) {
        return SwingUI.checkModifiers(evt.getModifiers(), 1) || SwingUI.checkModifiers(evt.getModifiers(), 8);
    }

    public static boolean checkModifiers(int modifiers, int mask) {
        return (modifiers & mask) == mask;
    }

    public static JButton createImageButton(Action action) {
        JButton button = new JButton(action);
        button.setHideActionText(true);
        button.setToolTipText(String.valueOf(action.getValue("Name")));
        button.setVerticalTextPosition(3);
        button.setOpaque(false);
        if (Settings.isMacApp()) {
            button.setPreferredSize(new Dimension(28, 27));
        } else {
            button.setPreferredSize(new Dimension(26, 26));
        }
        return button;
    }

    public static void installAction(JComponent component, KeyStroke keystroke, Action action) {
        SwingUI.installAction(component, 1, keystroke, action);
    }

    public static void installAction(JComponent component, int condition, KeyStroke keystroke, Action action) {
        Object key = action.getValue("Name");
        if (key == null) {
            throw new IllegalArgumentException("Action must have a name");
        }
        component.getInputMap(condition).put(keystroke, key);
        component.getActionMap().put(key, action);
        if (keystroke.getKeyCode() == 127) {
            KeyStroke macKeyStroke = KeyStroke.getKeyStroke(8, keystroke.getModifiers(), keystroke.isOnKeyRelease());
            String macKey = "mac." + action.getValue("Name");
            component.getInputMap(condition).put(macKeyStroke, macKey);
            component.getActionMap().put(macKey, action);
        }
    }

    public static UndoManager installUndoSupport(JTextComponent component) {
        UndoManager undoSupport = new UndoManager();
        component.getDocument().addUndoableEditListener(undoSupport);
        SwingUI.installAction(component, KeyStroke.getKeyStroke(90, 2), SwingUI.newAction("Undo", evt -> {
            if (undoSupport.canUndo()) {
                undoSupport.undo();
            }
        }));
        SwingUI.installAction(component, KeyStroke.getKeyStroke(89, 2), SwingUI.newAction("Redo", evt -> {
            if (undoSupport.canRedo()) {
                undoSupport.redo();
            }
        }));
        return undoSupport;
    }

    public static boolean isMaximized(Frame frame) {
        return (frame.getExtendedState() & 6) != 0;
    }

    public static List<String> showMultiValueInputDialog(Object message, String initialValue, String title, Component parent) {
        String input = SwingUI.showInputDialog(message, initialValue, title, parent);
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        for (char separator : new char[]{'|', ';'}) {
            if (input.indexOf(separator) < 0) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (String field : input.split(Pattern.quote(Character.toString(separator)))) {
                if ((field = field.trim()).length() <= 0) continue;
                values.add(field);
            }
            if (values.size() <= 0) continue;
            return values;
        }
        return Collections.singletonList(input);
    }

    public static String showInputDialog(Object message, String initialValue, String title, Component parent) {
        StringBuilder buffer = new StringBuilder();
        SwingUI.runOnEventDispatchThread(() -> {
            Object value = JOptionPane.showInputDialog(parent, message, title, -1, null, null, initialValue);
            if (value != null) {
                buffer.append(value.toString().trim());
            }
        });
        return buffer.length() == 0 ? null : buffer.toString();
    }

    public static Window getWindow(Object component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        if (component instanceof Component) {
            return SwingUtilities.getWindowAncestor((Component)component);
        }
        return null;
    }

    public static Point getOffsetLocation(Window owner) {
        if (owner == null) {
            Window[] toplevel = Window.getOwnerlessWindows();
            if (toplevel.length == 0) {
                return new Point(120, 80);
            }
            owner = toplevel[0];
        }
        Point p = owner.getLocation();
        Dimension d = owner.getSize();
        return new Point(p.x + d.width / 4, p.y + d.height / 7);
    }

    public static Image getImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2d = image.createGraphics();
        icon.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        return image;
    }

    public static Dimension getDimension(Icon icon) {
        return new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }

    public static Timer invokeLater(int delay, Runnable runnable) {
        Timer timer = new Timer(delay, evt -> runnable.run());
        timer.setRepeats(false);
        timer.start();
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withWaitCursor(Object source, BackgroundRunnable runnable) {
        Optional<Window> window = Optional.ofNullable(SwingUI.getWindow(source));
        try {
            window.ifPresent(w -> w.setCursor(Cursor.getPredefinedCursor(3)));
            runnable.run();
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, e, e::getMessage);
        }
        finally {
            window.ifPresent(w -> w.setCursor(Cursor.getDefaultCursor()));
        }
    }

    public static WindowAdapter windowClosed(final Consumer<WindowEvent> handler) {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                handler.accept(evt);
            }
        };
    }

    public static MouseAdapter mouseClicked(final Consumer<MouseEvent> handler) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                handler.accept(evt);
            }
        };
    }

    public static JButton newButton(String name, Consumer<ActionEvent> action) {
        return new JButton(new LambdaAction(name, null, action));
    }

    public static JButton newButton(String name, Icon icon, Consumer<ActionEvent> action) {
        return new JButton(new LambdaAction(name, icon, action));
    }

    public static Action newAction(String name, Consumer<ActionEvent> action) {
        return new LambdaAction(name, null, action);
    }

    public static Action newAction(String name, Icon icon, Consumer<ActionEvent> action) {
        return new LambdaAction(name, icon, action);
    }

    public static <T> T onSecondaryLoop(BackgroundSupplier<T> supplier) throws ExecutionException, InterruptedException {
        SecondaryLoop secondaryLoop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
        SwingWorker<T, Void> worker = SwingUI.newSwingWorker(supplier, null, null, secondaryLoop::exit);
        worker.execute();
        secondaryLoop.enter();
        return worker.get();
    }

    public static SwingWorker<Void, Void> newSwingWorker(BackgroundRunnable doInBackground) {
        return new SwingRunnable(doInBackground);
    }

    public static <T> SwingWorker<T, Void> newSwingWorker(BackgroundSupplier<T> doInBackground, Consumer<T> done) {
        return new SwingLambda(doInBackground, done, null, null);
    }

    public static <T> SwingWorker<T, Void> newSwingWorker(BackgroundSupplier<T> doInBackground, Consumer<T> done, Consumer<Exception> error) {
        return new SwingLambda(doInBackground, done, error, null);
    }

    public static <T> SwingWorker<T, Void> newSwingWorker(BackgroundSupplier<T> doInBackground, Consumer<T> done, Runnable close) {
        return new SwingLambda(doInBackground, done, null, close);
    }

    public static <T> SwingWorker<T, Void> newSwingWorker(BackgroundSupplier<T> doInBackground, Consumer<T> done, Consumer<Exception> error, Runnable close) {
        return new SwingLambda(doInBackground, done, error, close);
    }

    public static void initJavaFX() {
        if (initJavaFX) {
            initJavaFX = false;
            new JFXPanel();
            Platform.setImplicitExit((boolean)false);
        }
    }

    public static void invokeJavaFX(Runnable r) {
        SwingUI.initJavaFX();
        Platform.runLater((Runnable)r);
    }

    private SwingUI() {
        throw new UnsupportedOperationException();
    }

    public static class DragDropRowTableUI
    extends BasicTableUI {
        @Override
        protected MouseInputListener createMouseInputListener() {
            return new DragDropRowMouseInputHandler();
        }

        protected class DragDropRowMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            protected DragDropRowMouseInputHandler() {
                super(DragDropRowTableUI.this);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (DragDropRowTableUI.this.table.getDragEnabled() && DragDropRowTableUI.this.table.getSelectionModel().getSelectionMode() == 2) {
                    DragDropRowTableUI.this.table.getTransferHandler().exportAsDrag(DragDropRowTableUI.this.table, e, 1);
                } else {
                    super.mouseDragged(e);
                }
            }
        }
    }

    private static class SwingLambda<T, V>
    extends SwingWorker<T, V> {
        private BackgroundSupplier<T> doInBackground;
        private Optional<Consumer<T>> done;
        private Optional<Consumer<Exception>> error;
        private Optional<Runnable> close;

        public SwingLambda(BackgroundSupplier<T> doInBackground, Consumer<T> done, Consumer<Exception> error, Runnable close) {
            this.doInBackground = doInBackground;
            this.done = Optional.ofNullable(done);
            this.error = Optional.ofNullable(error);
            this.close = Optional.ofNullable(close);
        }

        @Override
        protected T doInBackground() throws Exception {
            return this.doInBackground.get();
        }

        @Override
        protected void done() {
            try {
                Object value = this.get();
                this.done.ifPresent(c -> c.accept(value));
            }
            catch (Exception e) {
                this.error.orElse(this::printException).accept(e);
            }
            finally {
                this.close.ifPresent(Runnable::run);
            }
        }

        private void printException(Exception e) {
            Logging.debug.log(Level.SEVERE, e, e::toString);
        }
    }

    @FunctionalInterface
    public static interface BackgroundSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface BackgroundRunnable {
        public void run() throws Exception;
    }

    private static class SwingRunnable
    extends SwingWorker<Void, Void> {
        private BackgroundRunnable doInBackground;

        public SwingRunnable(BackgroundRunnable doInBackground) {
            this.doInBackground = doInBackground;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.doInBackground.run();
            return null;
        }
    }

    private static class LambdaAction
    extends AbstractAction {
        private Consumer<ActionEvent> action;

        public LambdaAction(String name, Icon icon, Consumer<ActionEvent> action) {
            super(name, icon);
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.accept(e);
        }
    }
}

